/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor;

import io.reactivex.Observable;
import io.reactivex.disposables.CompositeDisposable;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.SetChangeListener;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.FilteredChildren;
import org.genericsystem.reactor.MetaBinding;
import org.genericsystem.reactor.RootHtmlDomNode;
import org.genericsystem.reactor.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlDomNode {
    private static final Logger logger = LoggerFactory.getLogger(HtmlDomNode.class);
    static int count = 0;
    private final String id;
    private HtmlDomNode parent;
    private Tag tag;
    private Context context;
    private boolean destroyed = false;
    final Consumer<Tag> tagAdder = this.tagAdder();
    private final CompositeDisposable disposables = new CompositeDisposable();
    private Map<Tag, Integer> sizeBySubTag = new IdentityHashMap<Tag, Integer>(){
        private static final long serialVersionUID = 6725720602283055930L;

        @Override
        public Integer get(Object key) {
            Integer size = (Integer)super.get(key);
            if (size == null) {
                size = 0;
                this.put((Tag)key, size);
            }
            return size;
        }
    };
    private ListChangeListener<Tag> tagListener = change -> {
        while (change.next()) {
            if (change.wasRemoved()) {
                change.getRemoved().forEach(childTag -> this.context.removeTag((Tag)childTag));
            }
            if (!change.wasAdded()) continue;
            change.getAddedSubList().forEach(this.tagAdder::accept);
        }
    };
    private final MapChangeListener<String, String> stylesListener = change -> {
        if (!change.wasAdded() || change.getValueAdded() == null || ((String)change.getValueAdded()).equals("")) {
            this.sendMessage(new JsonObject().put("msgType", "RS").put("nodeId", this.getId()).put("styleProperty", (String)change.getKey()));
        } else if (change.wasAdded()) {
            this.sendMessage(new JsonObject().put("msgType", "AS").put("nodeId", this.getId()).put("styleProperty", (String)change.getKey()).put("styleValue", (String)change.getValueAdded()));
        }
    };
    private final MapChangeListener<String, String> attributesListener = change -> {
        if (!change.wasAdded() || change.getValueAdded() == null || ((String)change.getValueAdded()).equals("")) {
            this.sendMessage(new JsonObject().put("msgType", "RA").put("nodeId", this.getId()).put("attributeName", (String)change.getKey()));
        } else if (change.wasAdded()) {
            this.sendMessage(new JsonObject().put("msgType", "AA").put("nodeId", this.getId()).put("attributeName", (String)change.getKey()).put("attributeValue", (String)change.getValueAdded()));
        }
    };
    private final SetChangeListener<String> styleClassesListener = change -> {
        if (change.wasAdded()) {
            this.sendMessage(new JsonObject().put("msgType", "AC").put("nodeId", this.getId()).put("styleClass", (String)change.getElementAdded()));
        } else {
            this.sendMessage(new JsonObject().put("msgType", "RC").put("nodeId", this.getId()).put("styleClass", (String)change.getElementRemoved()));
        }
    };
    private final ChangeListener<String> textListener = (o, old, newValue) -> this.sendMessage(new JsonObject().put("msgType", "UT").put("nodeId", this.getId()).put("textContent", newValue != null ? newValue : ""));
    private final Map<Tag, ChangeListener<MetaBinding<?>>> metaBindingListeners = new HashMap<Tag, ChangeListener<MetaBinding<?>>>(){
        private static final long serialVersionUID = 6179552869588758790L;

        @Override
        public ChangeListener<MetaBinding<?>> get(Object key) {
            ChangeListener listener = (ChangeListener)super.get(key);
            if (listener == null && key instanceof Tag) {
                Tag childTag = (Tag)key;
                listener = (o, ov, nv) -> {
                    HtmlDomNode.this.context.removeTag(childTag);
                    HtmlDomNode.this.updateMetaBinding(childTag, nv);
                };
                this.put(childTag, listener);
            }
            return listener;
        }
    };
    private final ChangeListener<Number> indexListener = (o, old, newValue) -> this.sendMessage(new JsonObject().put("msgType", "US").put("nodeId", this.getId()).put("selectedIndex", (Object)(newValue != null ? (Number)((Number)newValue) : (Number)0)));

    public HtmlDomNode(HtmlDomNode parent, Context context, Tag tag) {
        this.id = String.format("%010d", Integer.parseInt(this.hashCode() + "")).substring(0, 10);
        this.parent = parent;
        this.tag = tag;
        this.context = context;
        tag.getRootTag().initDomNode(this);
    }

    protected <BETWEEN> void init(int index) {
        this.context.register(this);
        if (this.parent != null) {
            this.insertChild(index);
        }
        if (this.parent != null) {
            BooleanBinding parentInCache = this.parent.getModelContext().isInCache();
            BooleanBinding booleanBinding = this.context.isInCache();
            this.tag.bindOptionalStyleClass("opaque", "isInCache", this.context, (ObservableValue<Boolean>)booleanBinding.and((ObservableBooleanValue)parentInCache.not()));
        }
        for (Consumer consumer : this.tag.getPreFixedBindings()) {
            this.context.getCache().safeExecute(() -> consumer.accept(this.context));
        }
        assert (!this.context.containsAttribute(this.tag, "filteredChildren"));
        FilteredChildren.FilteredTagChildren filteredChildren = new FilteredChildren.FilteredTagChildren(this.tag, this.context);
        this.tag.addContextAttribute("filteredChildren", this.context, filteredChildren);
        for (Tag childTag : filteredChildren.filteredList) {
            this.tagAdder.accept(childTag);
        }
        filteredChildren.filteredList.addListener(this.tagListener);
        for (Consumer<Context> binding : this.tag.getPostFixedBindings()) {
            this.context.getCache().safeExecute(() -> binding.accept(this.context));
        }
    }

    void destroy() {
        assert (!this.destroyed) : "Node : " + this.getId();
        this.destroyed = true;
        ((FilteredChildren.FilteredTagChildren)this.tag.getContextAttribute((String)"filteredChildren", (Context)this.context)).filteredList.removeListener(this.tagListener);
        for (Tag childTag : this.tag.getObservableChildren()) {
            childTag.getMetaBindingProperty().removeListener(this.metaBindingListeners.get(childTag));
        }
        this.disposables.dispose();
        this.tag.getDomNodeTextProperty(this.context).removeListener(this.textListener);
        this.tag.getDomNodeStyles(this.context).removeListener(this.stylesListener);
        this.tag.getDomNodeAttributes(this.context).removeListener(this.attributesListener);
        this.tag.getDomNodeStyleClasses(this.context).removeListener(this.styleClassesListener);
        this.getRootHtmlDomNode().remove(this.getId());
        if (this.parent != null) {
            this.parent.decrementSize(this.tag);
        }
    }

    public CompositeDisposable getDisposables() {
        return this.disposables;
    }

    public List<HtmlDomNode> getChildren() {
        ArrayList<HtmlDomNode> result = new ArrayList<HtmlDomNode>();
        ObservableList<Tag> subTags = this.tag.getObservableChildren();
        for (Tag subTag : subTags) {
            if (subTag.getMetaBinding() == null) {
                result.add(this.context.getHtmlDomNode(subTag));
                continue;
            }
            for (Context subContext : this.context.getSubContexts(subTag)) {
                result.add(subContext.getHtmlDomNode(subTag));
            }
        }
        return result;
    }

    private <BETWEEN> Consumer<Tag> tagAdder() {
        return childTag -> {
            Property metaBinding = childTag.getMetaBindingProperty();
            metaBinding.addListener(this.metaBindingListeners.get(childTag));
            this.updateMetaBinding((Tag)childTag, (MetaBinding)metaBinding.getValue());
        };
    }

    private <BETWEEN> void updateMetaBinding(Tag childTag, MetaBinding<BETWEEN> metaBinding) {
        if (metaBinding != null) {
            if (this.context.getSubContexts(childTag) == null) {
                this.context.setSubContexts(childTag, (ObservableList<Context>)FXCollections.observableArrayList());
                Observable<MetaBinding.IndexedSubContext> subContexts = metaBinding.buildFilteredChildren(this.context, childTag);
                this.disposables.add(subContexts.subscribe(sc -> {
                    Context subContext = sc.getContext();
                    if (sc.getCreate()) {
                        if (this.context.addSubContext(childTag, subContext)) {
                            childTag.createNode(this, subContext).init(this.computeIndex(sc.getIndex(), childTag));
                        }
                    } else {
                        subContext.removeTag(childTag);
                        if (sc.getIndex() == -1) {
                            this.context.getSubContexts(childTag).forEach(c_ -> {
                                if (c_.equals(subContext)) {
                                    c_.destroy();
                                }
                            });
                        }
                        this.context.getSubContexts(childTag).remove((Object)subContext);
                    }
                }, e -> logger.error("Error on filtered contexts subscriber.", e)));
            }
        } else if (this.context.getHtmlDomNode(childTag) == null) {
            childTag.createNode(this, this.context).init(this.computeIndex(0, childTag));
        }
    }

    private int computeIndex(int indexInChildren, Tag childElement) {
        for (Tag child : this.context.getRootContext().getObservableChildren(this.tag)) {
            if (child == childElement) {
                return indexInChildren;
            }
            indexInChildren += this.sizeBySubTag.get(child).intValue();
        }
        return indexInChildren;
    }

    public Context getModelContext() {
        return this.context;
    }

    protected RootHtmlDomNode getRootHtmlDomNode() {
        return this.parent.getRootHtmlDomNode();
    }

    void insertChild(int index) {
        this.parent.incrementSize(this.tag);
        this.sendAdd(index);
        this.getRootHtmlDomNode().add(this.getId(), this);
    }

    private void incrementSize(Tag child) {
        this.sizeBySubTag.put(child, this.sizeBySubTag.get(child) + 1);
    }

    private void decrementSize(Tag child) {
        int size = this.sizeBySubTag.get(child) - 1;
        assert (size >= 0);
        if (size == 0) {
            this.sizeBySubTag.remove(child);
        } else {
            this.sizeBySubTag.put(child, size);
        }
    }

    public Sender getSender() {
        return this.parent.getSender();
    }

    public ChangeListener<Number> getIndexListener() {
        return this.indexListener;
    }

    public ChangeListener<String> getTextListener() {
        return this.textListener;
    }

    public MapChangeListener<String, String> getStylesListener() {
        return this.stylesListener;
    }

    public MapChangeListener<String, String> getAttributesListener() {
        return this.attributesListener;
    }

    public SetChangeListener<String> getStyleClassesListener() {
        return this.styleClassesListener;
    }

    public void sendAdd(int index) {
        JsonObject jsonObj = new JsonObject().put("msgType", "A");
        jsonObj.put("parentId", this.getParentId());
        jsonObj.put("nodeId", this.id);
        jsonObj.put("tagHtml", this.getTag().getTag());
        jsonObj.put("nextId", Integer.valueOf(index));
        this.sendMessage(jsonObj);
    }

    public void sendRemove() {
        this.sendMessage(new JsonObject().put("msgType", "R").put("nodeId", this.id));
    }

    public void sendMessage(JsonObject jsonObj) {
        jsonObj.put("count", Integer.valueOf(count++));
        this.getSender().send(jsonObj.encode());
    }

    public String getId() {
        return this.id;
    }

    public String getParentId() {
        return this.parent.getId();
    }

    public Tag getTag() {
        return this.tag;
    }

    public void handleMessage(JsonObject json) {
    }

    public String toHTMLString() {
        String tagText = this.tag.getTag();
        String classes = this.tag.getDomNodeStyleClasses(this.context).stream().collect(Collectors.joining(" "));
        classes = "section".equals(tagText) || "div".equals(tagText) || "header".equals(tagText) || "footer".equals(tagText) ? (classes = classes + " adding") : classes;
        String styles = this.tag.getDomNodeStyles(this.context).entrySet().stream().map(m -> (String)m.getKey() + ": " + (String)m.getValue()).collect(Collectors.joining("; "));
        String tagAttributes = this.tag.getDomNodeAttributes(this.context).entrySet().stream().filter(m -> m.getValue() != null && !((String)m.getValue()).isEmpty()).map(m -> (String)m.getKey() + "=\"" + (String)m.getValue() + "\"").collect(Collectors.joining(""));
        String body = "\n<" + tagText + " id=\"" + this.id + "\"";
        if (!classes.equals("")) {
            body = body + " class=\"" + classes + "\"";
        }
        if (!styles.equals("")) {
            body = body + " style=\"" + styles + "\"";
        }
        body = body + tagAttributes + ">";
        for (HtmlDomNode node : this.getChildren()) {
            body = body + node.toHTMLString();
        }
        String tagValue = (String)this.tag.getDomNodeTextProperty(this.context).getValue();
        if (tagValue != null) {
            body = body + tagValue;
        }
        body = body + "</" + tagText + ">\n";
        return body;
    }

    public static class HtmlDomNodeSelect
    extends HtmlDomNode {
        public HtmlDomNodeSelect(HtmlDomNode parent, Context context, Tag tag) {
            super(parent, context, tag);
        }

        @Override
        public void handleMessage(JsonObject json) {
            if ("U".equals(json.getString("msgType"))) {
                this.getTag().getSelectionIndex(this.getModelContext()).setValue((Object)json.getInteger("selectedIndex"));
            }
        }
    }

    public static class HtmlDomNodeInputText
    extends HtmlDomNode {
        public HtmlDomNodeInputText(HtmlDomNode parent, Context context, Tag tag) {
            super(parent, context, tag);
        }

        @Override
        public void handleMessage(JsonObject json) {
            Property<Consumer<Object>> action;
            super.handleMessage(json);
            if ("A".equals(json.getString("msgType")) && (action = this.getTag().getActionProperty(this.getModelContext())) != null) {
                ((Consumer)action.getValue()).accept(new Object());
            }
            if ("U".equals(json.getString("msgType"))) {
                this.getTag().getDomNodeAttributes(this.getModelContext()).put((Object)"value", (Object)json.getString("textContent"));
            }
        }
    }

    public static class HtmlDomNodeCheckbox
    extends HtmlDomNode {
        public HtmlDomNodeCheckbox(HtmlDomNode parent, Context context, Tag tag) {
            super(parent, context, tag);
        }

        @Override
        public void handleMessage(JsonObject json) {
            this.getTag().getDomNodeAttributes(this.getModelContext()).put((Object)"checked", (Object)(json.getBoolean("checked") != false ? "checked" : ""));
        }
    }

    public static class HtmlDomNodeAction
    extends HtmlDomNode {
        public HtmlDomNodeAction(HtmlDomNode parent, Context context, Tag tag) {
            super(parent, context, tag);
        }

        @Override
        public void handleMessage(JsonObject json) {
            ((Consumer)this.getTag().getActionProperty(this.getModelContext()).getValue()).accept(new Object());
        }
    }

    public static interface Sender {
        public void send(String var1);
    }
}

