/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor.gscomponents;

import java.io.Serializable;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.util.StringConverter;
import org.genericsystem.common.Generic;
import org.genericsystem.defaults.DefaultGeneric;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.EncryptionUtils;
import org.genericsystem.reactor.ReactorStatics;
import org.genericsystem.reactor.contextproperties.ConvertedValueDefaults;
import org.genericsystem.reactor.contextproperties.PasswordDefaults;
import org.genericsystem.reactor.contextproperties.SelectionDefaults;
import org.genericsystem.reactor.gscomponents.HtmlTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputTextWithConversion<T extends Serializable>
extends HtmlTag.HtmlInputText
implements ConvertedValueDefaults {
    static final Logger log = LoggerFactory.getLogger(InputTextWithConversion.class);

    public InputTextWithConversion() {
        this.initInput();
    }

    protected void initInput() {
        this.createConvertedValueProperty();
        this.storeInvalidProperty(model -> Bindings.createBooleanBinding(() -> {
            boolean required = model.getGeneric().isRequiredConstraintEnabled(0);
            String value = (String)this.getDomNodeAttributes((Context)model).get((Object)"value");
            if (value == null || value.trim().isEmpty()) {
                return required;
            }
            try {
                this.getConverter((Context)model).fromString(value);
                return false;
            }
            catch (Exception e) {
                return true;
            }
        }, (Observable[])new Observable[]{this.getDomNodeAttributes((Context)model)}));
        this.bindOptionalStyleClass("invalid", "invalid");
        this.bindBiDirectionalAttributeOnEnter("value", "value");
    }

    private void bindBiDirectionalAttributeOnEnter(String propertyName, String attributeName) {
        this.bindAction(model -> {
            try {
                this.getContextProperty(propertyName, (Context)model).setValue(this.getConverter((Context)model).fromString((String)this.getDomNodeAttributes((Context)model).get((Object)attributeName)));
            }
            catch (Exception ignore) {
                log.info("Conversion exception: {}.", (Object)ignore.toString());
            }
        });
        this.addPrefixBinding(model -> {
            ChangeListener listener = (o, old, newValue) -> {
                String cfr_ignored_0 = (String)this.getDomNodeAttributes((Context)model).put((Object)attributeName, (Object)this.getConverter((Context)model).toString((Object)((Serializable)newValue)));
            };
            this.getContextProperty(propertyName, (Context)model).addListener(listener);
        });
    }

    public StringConverter<T> getConverter(Context model) {
        Class<String> clazz = model.getGeneric().getInstanceValueClassConstraint();
        if (clazz == null) {
            clazz = String.class;
        }
        return ReactorStatics.STRING_CONVERTERS.get(clazz);
    }

    public static class PasswordInput
    extends InputTextWithConversion<byte[]>
    implements PasswordDefaults {
        public PasswordInput() {
            this.addAttribute("type", "password");
        }

        @Override
        public StringConverter<byte[]> getConverter(final Context context) {
            return new StringConverter<byte[]>(){

                public String toString(byte[] hash) {
                    return null;
                }

                public byte[] fromString(String password) {
                    if (password.length() < 8) {
                        throw new IllegalStateException("Password must be at least 8 characters.");
                    }
                    Property<byte[]> saltProperty = this.getSaltProperty(context);
                    if (saltProperty.getValue() == null) {
                        saltProperty.setValue((Object)EncryptionUtils.generateSalt());
                    }
                    return EncryptionUtils.getEncryptedPassword(password, (byte[])saltProperty.getValue());
                }
            };
        }
    }

    public static class InputTextEditorWithConversionForDatalist<T extends Serializable>
    extends InputTextEditorWithConversion<T>
    implements SelectionDefaults {
        @Override
        protected Generic updateGeneric(Context context, Serializable newValue) {
            return (Generic)context.getGenerics()[1].updateComponent(context.getGeneric().getMeta().setInstance(newValue, (DefaultGeneric[])new Generic[0]), context.getGenerics()[1].getComponents().indexOf(context.getGeneric()));
        }
    }

    public static class InputTextEditorWithConversion<T extends Serializable>
    extends InputTextWithConversion<T>
    implements SelectionDefaults {
        @Override
        protected void initInput() {
            super.initInput();
            this.initValueProperty(model -> model.getGeneric().getValue());
            this.addConvertedValueChangeListener((model, nva) -> {
                if (nva != null) {
                    Generic updatedGeneric = this.updateGeneric((Context)model, (Serializable)nva);
                    Property<Generic> genericProperty = this.getUpdatedGenericProperty((Context)model);
                    if (genericProperty != null) {
                        genericProperty.setValue((Object)updatedGeneric);
                    }
                }
            });
        }

        protected Generic updateGeneric(Context context, Serializable newValue) {
            return (Generic)context.getGeneric().updateValue(newValue);
        }

        @Override
        public StringConverter<T> getConverter(Context model) {
            Class clazz = model.getGeneric().getMeta().getInstanceValueClassConstraint();
            if (clazz == null) {
                clazz = model.getGeneric().getValue() != null ? model.getGeneric().getValue().getClass() : String.class;
            }
            return ReactorStatics.STRING_CONVERTERS.get(clazz);
        }
    }
}

