/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor.contextproperties;

import java.io.Serializable;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.contextproperties.ContextProperty;

public interface ConvertedValueDefaults
extends ContextProperty {
    public static final String VALUE = "value";
    public static final String INVALID = "invalid";

    default public void createConvertedValueProperty() {
        this.createNewContextProperty(VALUE);
    }

    default public Property<Serializable> getConvertedValueProperty(Context model) {
        return this.getContextProperty(VALUE, model);
    }

    default public <T> void initValueProperty(Function<Context, T> getInitialValue) {
        this.setContextPropertyValue(VALUE, getInitialValue);
    }

    default public <T extends Serializable> void addConvertedValueChangeListener(BiConsumer<Context, T> listener) {
        this.addContextPropertyChangeListener(VALUE, listener);
    }

    default public <T> void storeInvalidProperty(Function<Context, ObservableValue<T>> applyOnModel) {
        this.addContextAttribute(INVALID, applyOnModel);
    }

    default public ObservableValue<Boolean> getInvalidObservable(Context model) {
        return this.getContextObservableValue(INVALID, model);
    }
}

