/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor.annotations;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.function.BiConsumer;
import org.genericsystem.reactor.Tag;
import org.genericsystem.reactor.annotations.DirectSelect;
import org.genericsystem.reactor.annotations.GenericProcess;
import org.genericsystem.reactor.annotations.Process;
import org.genericsystem.reactor.context.TagSwitcher;
import org.genericsystem.reactor.extended.ExtendedRootTag;
import org.genericsystem.reactor.gscomponents.TagImpl;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@Repeatable(value=Modes.class)
@Process(value=SwichProcessor.class)
@GenericProcess(value=SwitchGenericProcessor.class)
public @interface Switch {
    public Class<? extends TagImpl>[] path() default {};

    public int[] pos() default {};

    public Class<? extends TagSwitcher>[] value();

    public static class SwitchGenericProcessor
    implements DirectSelect.AnnotationProcessorNoActionWithContext {
        @Override
        public void setAnnotation(ExtendedRootTag.GTag gTag, Annotation annotation) {
            gTag.setArrayValueAnnotation(Switch.class, null, ((Switch)annotation).value(), ((Switch)annotation).path(), ((Switch)annotation).pos());
        }

        @Override
        public void onRemove(Tag tag, ExtendedRootTag.GTagAnnotation gTagAnnotation, ExtendedRootTag.GTagAnnotationContent annotationContent) {
            for (Class<?> switcherClass : annotationContent.getClassArrayContent()) {
                tag.getObservableSwitchers().removeAll((Collection)tag.getObservableSwitchers().filtered(switcher -> switcherClass.equals(switcher.getClass())));
            }
        }

        @Override
        public void onAdd(Tag tag, ExtendedRootTag.GTagAnnotation gTagAnnotation, ExtendedRootTag.GTagAnnotationContent annotationContent) {
            tag.getRootTag().processSwitch(tag, annotationContent.getClassArrayContent());
        }
    }

    public static class SwichProcessor
    implements BiConsumer<Annotation, Tag> {
        @Override
        public void accept(Annotation annotation, Tag tag) {
            tag.getRootTag().processSwitch(tag, ((Switch)annotation).value());
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Modes {
        public Switch[] value();
    }
}

