/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor.annotations;

import io.vertx.core.json.JsonObject;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.function.BiConsumer;
import org.genericsystem.api.core.TagAnnotation;
import org.genericsystem.common.Generic;
import org.genericsystem.defaults.DefaultGeneric;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.Tag;
import org.genericsystem.reactor.annotations.GenericProcess;
import org.genericsystem.reactor.annotations.Process;
import org.genericsystem.reactor.extended.ExtendedAnnotationsManager;
import org.genericsystem.reactor.extended.ExtendedRootTag;
import org.genericsystem.reactor.gscomponents.TagImpl;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@Repeatable(value=TagNames.class)
@Process(value=TagNameProcessor.class)
@GenericProcess(value=TagNameGenericProcessor.class)
public @interface TagName {
    public static final String A = "a";
    public static final String BUTTON = "button";
    public static final String CHECKBOX = "checkbox";
    public static final String DATALIST = "datalist";
    public static final String DIV = "div";
    public static final String FOOTER = "footer";
    public static final String H1 = "h1";
    public static final String H2 = "h2";
    public static final String H3 = "h3";
    public static final String H4 = "h4";
    public static final String H5 = "h5";
    public static final String H6 = "h6";
    public static final String HEADER = "header";
    public static final String IMG = "img";
    public static final String INPUT = "input";
    public static final String LABEL = "label";
    public static final String LI = "li";
    public static final String OPTION = "option";
    public static final String P = "p";
    public static final String RADIO = "radio";
    public static final String SECTION = "section";
    public static final String SELECT = "select";
    public static final String SPAN = "span";
    public static final String STRONG = "strong";
    public static final String TEXT = "text";
    public static final String UL = "ul";
    public static final String BR = "br";

    public Class<? extends TagImpl>[] path() default {};

    public String value();

    public String type() default "text";

    public int[] pos() default {};

    public static class TagNameGenericProcessor
    implements ExtendedAnnotationsManager.IGenericAnnotationProcessor {
        @Override
        public void setAnnotation(ExtendedRootTag.GTag gTag, Annotation annotation) {
            TagName tagName = (TagName)annotation;
            ExtendedRootTag.GTagAnnotation tagNameAnnotation = (ExtendedRootTag.GTagAnnotation)gTag.setHolder((DefaultGeneric)gTag.getRoot().find(ExtendedRootTag.TagType.TagAnnotationAttribute.class), (Serializable)new TagAnnotation(TagName.class, (Class[])tagName.path(), tagName.pos()), (DefaultGeneric[])new Generic[0]);
            tagNameAnnotation.setHolder((DefaultGeneric)gTag.getRoot().find(ExtendedRootTag.TagType.TagAnnotationContentAttribute.class), (Serializable)((Object)new JsonObject().put("value", tagName.value()).put("type", tagName.type()).encodePrettily()), (DefaultGeneric[])new Generic[0]);
        }

        @Override
        public void onRemove(Tag tag, Context context, ExtendedRootTag.GTagAnnotation gTagAnnotation, ExtendedRootTag.GTagAnnotationContent annotationContent) {
            if (tag.getMetaBinding() == null) {
                context.removeTag(tag);
            } else {
                context.getParent().removeTag(tag);
            }
        }

        @Override
        public void onAdd(Tag tag, Context context, ExtendedRootTag.GTagAnnotation gTagAnnotation, ExtendedRootTag.GTagAnnotationContent annotationContent) {
            if (tag.getMetaBinding() == null) {
                context.addTag(tag);
            } else {
                context.getParent().addTag(tag);
            }
        }

        @Override
        public void onRemove(Tag tag, ExtendedRootTag.GTagAnnotation gTagAnnotation, ExtendedRootTag.GTagAnnotationContent annotationContent) {
            tag.setTag(null);
            tag.setDomNodeClass(null);
        }

        @Override
        public void onAdd(Tag tag, ExtendedRootTag.GTagAnnotation gTagAnnotation, ExtendedRootTag.GTagAnnotationContent annotationContent) {
            JsonObject jsonContent = annotationContent.getJsonValue();
            tag.getRootTag().processTagName(tag, jsonContent.getString("value"), jsonContent.getString("type"));
        }
    }

    public static class TagNameProcessor
    implements BiConsumer<Annotation, Tag> {
        @Override
        public void accept(Annotation annotation, Tag tag) {
            tag.getRootTag().processTagName(tag, ((TagName)annotation).value(), ((TagName)annotation).type());
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface TagNames {
        public TagName[] value();
    }
}

