/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor;

import io.reactivex.Observable;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.util.StringConverter;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.common.Generic;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.HtmlDomNode;
import org.genericsystem.reactor.MetaBinding;
import org.genericsystem.reactor.ReactorStatics;
import org.genericsystem.reactor.RootTag;
import org.genericsystem.reactor.TagNode;
import org.genericsystem.reactor.context.ForEachExtractor;
import org.genericsystem.reactor.context.TagSwitcher;
import org.genericsystem.reactor.contextproperties.ActionDefaults;
import org.genericsystem.reactor.contextproperties.AttributesDefaults;
import org.genericsystem.reactor.contextproperties.DisplayDefaults;
import org.genericsystem.reactor.contextproperties.GSBuilderDefaults;
import org.genericsystem.reactor.contextproperties.GenericStringDefaults;
import org.genericsystem.reactor.contextproperties.SelectionDefaults;
import org.genericsystem.reactor.contextproperties.StepperDefaults;
import org.genericsystem.reactor.contextproperties.StyleClassesDefaults;
import org.genericsystem.reactor.contextproperties.StylesDefaults;
import org.genericsystem.reactor.contextproperties.TextPropertyDefaults;
import org.genericsystem.reactor.contextproperties.UserRoleDefaults;
import org.genericsystem.reactor.gscomponents.TagImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Tag
extends TagNode,
ActionDefaults,
SelectionDefaults,
StepperDefaults,
GSBuilderDefaults,
TextPropertyDefaults,
StylesDefaults,
AttributesDefaults,
StyleClassesDefaults,
GenericStringDefaults,
DisplayDefaults,
UserRoleDefaults {
    public static final Logger log = LoggerFactory.getLogger(Tag.class);

    public String getTag();

    public void setTag(String var1);

    public Class<? extends HtmlDomNode> getDomNodeClass();

    public void setDomNodeClass(Class<? extends HtmlDomNode> var1);

    public List<Consumer<Context>> getPreFixedBindings();

    public List<Consumer<Context>> getPostFixedBindings();

    public <BETWEEN> MetaBinding<BETWEEN> getMetaBinding();

    public <BETWEEN> Property<MetaBinding<BETWEEN>> getMetaBindingProperty();

    public <BETWEEN> void setMetaBinding(MetaBinding<BETWEEN> var1);

    @Override
    default public void addPrefixBinding(Consumer<Context> consumer) {
        this.getPreFixedBindings().add(consumer);
    }

    @Override
    default public void addPostfixBinding(Consumer<Context> consumer) {
        this.getPostFixedBindings().add(consumer);
    }

    default public void bindOptionalStyleClass(String styleClass, String propertyName) {
        this.addPrefixBinding(context -> this.bindOptionalStyleClass(styleClass, propertyName, (Context)context));
    }

    default public void bindOptionalStyleClass(String styleClass, String propertyName, Context context) {
        ObservableValue optional = this.getContextObservableValue(propertyName, context);
        ObservableSet<String> styleClasses = this.getDomNodeStyleClasses(context);
        Consumer<Boolean> consumer = bool -> {
            if (Boolean.TRUE.equals(bool)) {
                styleClasses.add(styleClass);
            } else {
                styleClasses.remove(styleClass);
            }
        };
        consumer.accept((Boolean)optional.getValue());
        optional.addListener((o, ov, nv) -> consumer.accept((Boolean)nv));
    }

    default public void bindOptionalStyleClass(String styleClass, String modelPropertyName, Function<Context, ObservableValue<Boolean>> applyOnModel) {
        this.addContextAttribute(modelPropertyName, applyOnModel);
        this.bindOptionalStyleClass(styleClass, modelPropertyName);
    }

    default public void bindOptionalStyleClass(String styleClass, String modelPropertyName, Context context, ObservableValue<Boolean> obs) {
        context.addContextAttribute(this, modelPropertyName, obs);
        this.bindOptionalStyleClass(styleClass, modelPropertyName, context);
    }

    default public void forEach2(Function<Context, Observable<Snapshot<Generic>>> applyOnModel) {
        this.setMetaBinding(MetaBinding.forEachMetaBinding(applyOnModel));
    }

    default public void forEach(ForEachExtractor observableListExtractor) {
        this.forEach2(model -> (Observable)observableListExtractor.apply(model.getGenerics()));
    }

    default public void forEach(Tag parent) {
        this.forEach(gs -> (Observable)parent.getObservableListExtractor().apply(gs));
    }

    default public void select(Function<Generic[], Generic> genericSupplier) {
        this.forEach(gs -> {
            Generic generic = (Generic)genericSupplier.apply((Generic[])gs);
            return Observable.just((Object)(generic != null ? Snapshot.singleton((Object)generic) : Snapshot.empty()));
        });
    }

    default public void select_(Function<Context, Observable<Snapshot<Context>>> applyOnModel) {
        this.setMetaBinding(MetaBinding.selectMetaBinding(applyOnModel));
    }

    default public void select__(Function<Context, Observable<Optional<Context>>> applyOnModelContext) {
        this.select_(context -> ((Observable)applyOnModelContext.apply((Context)context)).map(opt -> opt.isPresent() ? Snapshot.singleton(opt.get()) : Snapshot.empty()));
    }

    default public void select(Class<?> genericClass) {
        this.forEach(gs -> Observable.just((Object)Snapshot.singleton((Object)gs[0].getRoot().find(genericClass))));
    }

    default public ForEachExtractor getObservableListExtractor() {
        return ForEachExtractor.SUBINSTANCES;
    }

    @Override
    default public <T> T getContextAttribute(String attributeName, Context context) {
        class AttributeComputer {
            AttributeComputer() {
            }

            T getAttribute(String attributeName, Context[] contexts) {
                for (Tag tag = Tag.this; tag != null && contexts[0] != null; tag = tag.getParent()) {
                    if (contexts[0].containsAttribute(tag, attributeName)) {
                        return contexts[0].getAttribute(tag, attributeName);
                    }
                    if (tag.getMetaBinding() == null || contexts[0].getHtmlDomNode((Tag)tag.getParent()) != null) continue;
                    contexts[0] = contexts[0].getParent();
                }
                return null;
            }
        }
        return new AttributeComputer().getAttribute(attributeName, new Context[]{context});
    }

    @Override
    default public <T> Property<T> getContextProperty(String propertyName, Context context) {
        return (Property)this.getContextAttribute(propertyName, context);
    }

    @Override
    default public <T> ObservableValue<T> getContextObservableValue(String propertyName, Context context) {
        return (ObservableValue)this.getContextAttribute(propertyName, context);
    }

    @Override
    default public <T> T getInheritedContextAttribute(String attributeName, Context[] context, Tag[] tag) {
        while (tag[0] != null && context[0] != null) {
            if (tag[0].getMetaBinding() != null && context[0].getHtmlDomNode((Tag)tag[0].getParent()) == null) {
                context[0] = context[0].getParent();
            }
            tag[0] = tag[0].getParent();
            if (context[0] == null || !context[0].containsAttribute(tag[0], attributeName)) continue;
            return context[0].getAttribute(tag[0], attributeName);
        }
        return null;
    }

    @Override
    default public <T extends Serializable> void addContextPropertyChangeListener(String propertyName, BiConsumer<Context, T> listener) {
        this.addPrefixBinding(context -> {
            ObservableValue observable = this.getContextObservableValue(propertyName, (Context)context);
            observable.addListener((o, old, nva) -> listener.accept((Context)context, (Object)nva));
        });
    }

    @Override
    default public <T> void addContextAttribute(String attributeName, Function<Context, T> applyOnModel) {
        this.addPrefixBinding(context -> context.addContextAttribute(this, attributeName, applyOnModel.apply((Context)context)));
    }

    @Override
    default public <T> void addContextAttribute(String attributeName, Context context, T value) {
        context.addContextAttribute(this, attributeName, value);
    }

    @Override
    default public <T> void setContextAttribute(String attributeName, Context context, T value) {
        context.setContextAttribute(this, attributeName, value);
    }

    @Override
    default public <T> void setContextAttribute(String attributeName, Function<Context, T> getValue) {
        this.addPrefixBinding(context -> this.setContextAttribute(attributeName, (Context)context, (Object)getValue.apply((Context)context)));
    }

    @Override
    default public <T> void setContextPropertyValue(String attributeName, Context context, T value) {
        context.setContextPropertyValue(this, attributeName, value);
    }

    @Override
    default public <T> void setContextPropertyValue(String attributeName, Function<Context, T> getValue) {
        this.addPrefixBinding(context -> this.setContextPropertyValue(attributeName, (Context)context, (Object)getValue.apply((Context)context)));
    }

    default public <T> void setInheritedContextPropertyValue(String attributeName, Context context, T value) {
        Property<T> contextProperty = this.getContextProperty(attributeName, context);
        if (contextProperty == null) {
            this.setContextPropertyValue(attributeName, context, value);
        } else {
            contextProperty.setValue(value);
        }
    }

    @Override
    default public void createNewContextProperty(String propertyName) {
        this.addPrefixBinding(context -> context.createNewContextProperty(this, propertyName));
    }

    default public void createNewContextProperty(String propertyName, Context context) {
        context.createNewContextProperty(this, propertyName);
    }

    @Override
    default public <T> void createNewInitializedProperty(String propertyName, Context context, T initialValue) {
        context.createNewContextProperty(this, propertyName);
        this.getContextProperty(propertyName, context).setValue(initialValue);
    }

    @Override
    default public <T> void createNewInitializedProperty(String propertyName, Function<Context, T> getInitialValue) {
        this.addPrefixBinding(context -> this.createNewInitializedProperty(propertyName, (Context)context, (Object)getInitialValue.apply((Context)context)));
    }

    default public void bindMapElement(String name, String propertyName, Function<Context, Map<String, String>> getMap) {
        this.addPrefixBinding(model -> {
            Map map = (Map)getMap.apply((Context)model);
            ChangeListener listener = (o, old, newValue) -> map.put(name, newValue);
            ObservableValue observable = this.getContextObservableValue(propertyName, (Context)model);
            observable.addListener(listener);
            map.put(name, observable.getValue());
        });
    }

    default public void bindBiDirectionalMapElement(String propertyName, String name, Function<Context, ObservableMap<String, String>> getMap) {
        this.bindBiDirectionalMapElement(propertyName, name, getMap, ReactorStatics.STRING_CONVERTERS.get(String.class));
    }

    default public <T extends Serializable> void bindBiDirectionalMapElement(String propertyName, String name, Function<Context, ObservableMap<String, String>> getMap, StringConverter<T> stringConverter) {
        this.bindBiDirectionalMapElement(propertyName, name, getMap, (Context model) -> stringConverter);
    }

    default public <T extends Serializable> void bindBiDirectionalMapElement(String propertyName, String name, Function<Context, ObservableMap<String, String>> getMap, Function<Context, StringConverter<T>> getStringConverter) {
        this.addPrefixBinding(modelContext -> {
            ObservableMap map = (ObservableMap)getMap.apply((Context)modelContext);
            StringConverter stringConverter = (StringConverter)getStringConverter.apply((Context)modelContext);
            ChangeListener listener = (o, old, newValue) -> {
                String cfr_ignored_0 = (String)map.put((Object)name, (Object)stringConverter.toString(newValue));
            };
            Property observable = this.getContextProperty(propertyName, (Context)modelContext);
            observable.addListener(listener);
            map.addListener(c -> {
                if (!name.equals(c.getKey())) {
                    return;
                }
                try {
                    observable.setValue(c.wasAdded() ? (Serializable)stringConverter.fromString((String)c.getValueAdded()) : null);
                }
                catch (Exception ignore) {
                    log.info("Conversion exception: {}.", (Object)ignore.toString());
                }
            });
            map.put((Object)name, (Object)stringConverter.toString(observable.getValue()));
        });
    }

    default public void addStyle(String propertyName, String value) {
        this.addPrefixBinding(context -> this.addStyle((Context)context, propertyName, value));
    }

    @Override
    default public void addStyle(Context context, String propertyName, String value) {
        this.getDomNodeStyles(context).put((Object)propertyName, (Object)value);
    }

    default public void bindStyle(String style, String modelPropertyName) {
        this.bindMapElement(style, modelPropertyName, model -> this.getDomNodeStyles((Context)model));
    }

    default public void bindStyle(String style, String propertyName, Function<Context, ObservableValue<String>> applyOnModel) {
        this.addContextAttribute(propertyName, applyOnModel);
        this.bindMapElement(style, propertyName, model -> this.getDomNodeStyles((Context)model));
    }

    default public void addStyleClasses(String ... styleClasses) {
        this.addPrefixBinding(model -> this.getDomNodeStyleClasses((Context)model).addAll(Arrays.asList(styleClasses)));
    }

    default public void addStyleClass(String styleClass) {
        this.addPrefixBinding(model -> this.getDomNodeStyleClasses((Context)model).add((Object)styleClass));
    }

    default public void addStyleClass(Context context, String styleClass) {
        this.getDomNodeStyleClasses(context).add((Object)styleClass);
    }

    default public void addAttribute(String attributeName, String value) {
        this.addPrefixBinding(model -> {
            String cfr_ignored_0 = (String)this.getDomNodeAttributes((Context)model).put((Object)attributeName, (Object)value);
        });
    }

    default public void addAttribute(Context context, String attributeName, String value) {
        this.getDomNodeAttributes(context).put((Object)attributeName, (Object)value);
    }

    default public void removeStyleClass(Context context, String styleClass) {
        this.getDomNodeStyleClasses(context).remove((Object)styleClass);
    }

    default public void removeStyleClass(String styleClass) {
        this.addPrefixBinding(context -> this.getDomNodeStyleClasses((Context)context).remove((Object)styleClass));
    }

    default public void bindAttribute(String attributeName, String propertyName) {
        this.bindMapElement(attributeName, propertyName, model -> this.getDomNodeAttributes((Context)model));
    }

    default public void bindAttribute(String attributeName, String propertyName, Function<Context, ObservableValue<String>> applyOnModel) {
        this.addContextAttribute(propertyName, applyOnModel);
        this.bindMapElement(attributeName, propertyName, model -> this.getDomNodeAttributes((Context)model));
    }

    default public void bindBiDirectionalAttribute(String propertyName, String attributeName) {
        this.bindBiDirectionalMapElement(propertyName, attributeName, model -> this.getDomNodeAttributes((Context)model));
    }

    default public <T extends Serializable> void bindBiDirectionalAttribute(String propertyName, String attributeName, StringConverter<T> stringConverter) {
        this.bindBiDirectionalMapElement(propertyName, attributeName, (Context model) -> this.getDomNodeAttributes((Context)model), stringConverter);
    }

    default public <T extends Serializable> void bindBiDirectionalAttribute(String propertyName, String attributeName, Function<Context, StringConverter<T>> getStringConverter) {
        this.bindBiDirectionalMapElement(propertyName, attributeName, (Context model) -> this.getDomNodeAttributes((Context)model), getStringConverter);
    }

    default public void bindOptionalBiDirectionalAttribute(String propertyName, String attributeName, String attributeValue) {
        this.bindOptionalBiDirectionalAttribute(propertyName, attributeName, attributeValue, null);
    }

    default public void bindOptionalBiDirectionalAttribute(String propertyName, String attributeName, final String attributeValue, final String attributeValueFalse) {
        this.bindBiDirectionalMapElement(propertyName, attributeName, (Context model) -> this.getDomNodeAttributes((Context)model), new StringConverter<Boolean>(){

            public String toString(Boolean bool) {
                return Boolean.TRUE.equals(bool) ? attributeValue : attributeValueFalse;
            }

            public Boolean fromString(String string) {
                return attributeValue.equals(string);
            }
        });
    }

    default public HtmlDomNode createNode(HtmlDomNode parent, Context context) {
        try {
            return this.getDomNodeClass().getConstructor(HtmlDomNode.class, Context.class, Tag.class).newInstance(parent, context, this);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    default public <T extends TagImpl> TagImpl createChild(Class<T> clazz) {
        TagImpl result = null;
        try {
            result = (TagImpl)clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(e);
        }
        result.initTag(this);
        return result;
    }

    default public void initTag(Tag parent) {
        this.setParent(parent);
        this.setTagNode(this.getRootTag().buildTagNode(this));
        this.getRootTag().processAnnotations(this);
        this.init();
        parent.getObservableChildren().add((Object)this);
    }

    @Override
    public ObservableList<Tag> getObservableChildren();

    public TagNode getTagNode();

    public void setTagNode(TagNode var1);

    default public void init() {
    }

    public <COMPONENT extends Tag> COMPONENT getParent();

    public void setParent(Tag var1);

    default public RootTag getRootTag() {
        return this.getParent().getRootTag();
    }

    public ObservableList<TagSwitcher> getObservableSwitchers();

    public void addSwitcher(TagSwitcher var1);

    default public String defaultToString() {
        return this.getTag() + " " + this.getClass().getName();
    }

    default public <T extends Tag> T find(Class<T> tagClass) {
        return this.find(tagClass, 0);
    }

    default public <T extends Tag> T find(Class<T> tagClass, int pos) {
        int posFound = 0;
        for (Tag child : this.getObservableChildren()) {
            if (!tagClass.isAssignableFrom(child.getClass())) continue;
            if (posFound == pos) {
                return (T)child;
            }
            ++posFound;
        }
        throw new IllegalStateException("No tag corresponding to class " + tagClass.getSimpleName() + " found, position " + pos + ".");
    }
}

