/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor.gscomponents;

import io.reactivex.Observable;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Map;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import org.genericsystem.api.core.exceptions.RollbackException;
import org.genericsystem.common.Generic;
import org.genericsystem.defaults.DefaultGeneric;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.EncryptionUtils;
import org.genericsystem.reactor.annotations.Attribute;
import org.genericsystem.reactor.annotations.BindAction;
import org.genericsystem.reactor.annotations.BindText;
import org.genericsystem.reactor.annotations.Children;
import org.genericsystem.reactor.annotations.ForEach;
import org.genericsystem.reactor.annotations.Select;
import org.genericsystem.reactor.annotations.SelectContext;
import org.genericsystem.reactor.annotations.SetText;
import org.genericsystem.reactor.annotations.Style;
import org.genericsystem.reactor.context.ContextAction;
import org.genericsystem.reactor.context.ForEachExtractor;
import org.genericsystem.reactor.context.GenericSelector;
import org.genericsystem.reactor.context.OptionalContextSelector;
import org.genericsystem.reactor.contextproperties.ComponentsDefaults;
import org.genericsystem.reactor.contextproperties.ConvertedValueDefaults;
import org.genericsystem.reactor.contextproperties.PasswordDefaults;
import org.genericsystem.reactor.contextproperties.SelectionDefaults;
import org.genericsystem.reactor.contextproperties.StepperDefaults;
import org.genericsystem.reactor.contextproperties.UserRoleDefaults;
import org.genericsystem.reactor.gscomponents.CheckBoxWithValue;
import org.genericsystem.reactor.gscomponents.Composite;
import org.genericsystem.reactor.gscomponents.FlexDirection;
import org.genericsystem.reactor.gscomponents.FlexDiv;
import org.genericsystem.reactor.gscomponents.HtmlTag;
import org.genericsystem.reactor.gscomponents.InputTextWithConversion;
import org.genericsystem.reactor.gscomponents.InputWithDatalist;
import org.genericsystem.reactor.gscomponents.InstancesTable;
import org.genericsystem.reactor.gscomponents.Modal;
import org.genericsystem.security.model.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Style.Styles(value={@Style(name="flex", value="1 1 0%"), @Style(name="overflow", value="hidden"), @Style(name="background-color", value="lightgrey"), @Style(name="padding-left", value="1px"), @Style(name="padding-top", value="1px"), @Style(path={Composite.class, InstancesTable.ValueComponents.class}, pos={-1, 0}, name="flex", value="0.3"), @Style(path={Composite.class, InstancesTable.ValueComponents.class}, name="color", value="white")})
@Style.ReverseFlexDirection(path={Composite.class})
@Style.GenericValueBackgroundColor(path={Composite.class, InstancesTable.ValueComponents.class, FlexDiv.class}, pos={-1, 0, -1}, value="#ea0084")
@Children.ChildrenMult(value={@Children(value={InstanceName.class, AttributeEdition.class}), @Children(path={InstanceName.class}, value={InstancesTable.ValueComponents.class, ValueComponentsEditor.class}), @Children(path={AttributeEdition.class}, value={InstancesTable.ValueComponents.class, AttributeContent.class}), @Children(path={Composite.class, InstancesTable.ValueComponents.class, Composite.Header.class}, pos={-1, 0, -1}, value={HtmlTag.HtmlLabel.GSLabelDisplayer.class}), @Children(path={AttributeEdition.class, Composite.Content.class}, value={PasswordHoldersEditor.class, HoldersEditor.class, MultiCheckbox.class}), @Children(path={InstanceName.class, ValueComponentsEditor.class}, value={Composite.Content.class, Composite.Header.class})})
@ForEach.ForEachs(value={@ForEach(path={AttributeEdition.class}, value=ForEachExtractor.ATTRIBUTES_OF_INSTANCES.class), @ForEach(path={AttributeEdition.class, AttributeContent.class}, value=ForEachExtractor.NO_FOR_EACH.class), @ForEach(path={AttributeEdition.class, InstancesTable.ValueComponents.class, Composite.Content.class}, value=ForEachExtractor.OTHER_COMPONENTS_2.class)})
@Select.Selects(value={@Select(path={InstanceName.class, InstancesTable.ValueComponents.class}, pos={0, 0}, value=GenericSelector.TYPE_SELECTOR.class), @Select(path={Composite.class, InstancesTable.ValueComponents.class, Composite.Header.class}, pos={-1, 0, -1}, value=GenericSelector.GENERIC_VALUE_DISPLAYER.class)})
public class InstanceEditor
extends FlexDiv
implements SelectionDefaults,
StepperDefaults {
    protected static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Style.FlexDirectionStyle(value=FlexDirection.ROW)
    public static class HorizontalInstanceEditor
    extends InstanceEditor {
    }

    @Style.Styles(value={@Style(name="justify-content", value="center"), @Style(name="height", value="100%"), @Style(name="text-decoration", value="none")})
    public static class ActionLink
    extends HtmlTag.HtmlHyperLink {
    }

    @Style(name="flex", value="1")
    public static class DatalistEditor
    extends InputWithDatalist
    implements ComponentsDefaults {
        @Override
        public void init() {
            super.init();
            this.addPostfixBinding(model -> {
                Map<Generic, Property<Serializable>> selectedComponents = this.getComponentsMap((Context)model);
                if (selectedComponents != null) {
                    selectedComponents.put(model.getGeneric(), this.find(InputTextWithConversion.class).getConvertedValueProperty((Context)model));
                }
            });
        }
    }

    public static class BooleanHolderAdderInput
    extends CheckBoxWithValue {
        @Override
        public void init() {
            this.addConvertedValueChangeListener((context, nva) -> ((ConvertedValueDefaults)this.getParent().getParent()).getConvertedValueProperty(context.getParent().getParent()).setValue(nva));
        }
    }

    public static class HolderAdderInput
    extends InputTextWithConversion {
        @Override
        public void init() {
            this.addConvertedValueChangeListener((context, nva) -> ((ConvertedValueDefaults)this.getParent().getParent()).getConvertedValueProperty(context.getParent().getParent()).setValue(nva));
        }
    }

    @Style.Styles(value={@Style(name="flex", value="1 0 auto"), @Style(path={Composite.Header.class, InputTextWithConversion.class}, name="flex", value="1"), @Style(path={Composite.Header.class, InputTextWithConversion.class}, name="width", value="100%")})
    @Children.ChildrenMult(value={@Children(value={Composite.Content.class, Composite.Header.class, ActionLink.class}), @Children(path={Composite.Header.class}, value={HolderAdderInput.class, BooleanHolderAdderInput.class}), @Children(path={Composite.Content.class}, value={DatalistEditor.class})})
    @Select.Selects(value={@Select(path={ActionLink.class}, value=GenericSelector.STRICT_ATTRIBUTE_SELECTOR.class), @Select(path={Composite.Header.class}, value=GenericSelector.GENERIC_VALUE_DISPLAYER.class), @Select(path={Composite.Header.class, HolderAdderInput.class}, value=GenericSelector.LABEL_DISPLAYER.class), @Select(path={Composite.Header.class, BooleanHolderAdderInput.class}, value=GenericSelector.CHECK_BOX_DISPLAYER.class)})
    @SetText(path={ActionLink.class}, value={"+"})
    @BindAction(path={ActionLink.class}, value={ContextAction.ADD_HOLDER.class})
    public static class HolderAdder
    extends InstancesTable.ValueComponents
    implements ComponentsDefaults,
    ConvertedValueDefaults {
        @Override
        public void init() {
            this.createComponentsMap();
            this.createConvertedValueProperty();
            this.addConvertedValueChangeListener((context, nva) -> {
                if (nva != null) {
                    context.getGenerics()[1].addHolder((DefaultGeneric)context.getGeneric(), nva, (DefaultGeneric[])new Generic[0]);
                }
            });
            this.addPostfixBinding(model -> {
                Map<Generic, Property<Serializable>> selectedComponents = this.getComponentsMap((Context)model);
                ChangeListener listener = (o, v, nva) -> {
                    Generic[] selectedGenerics = (Generic[])selectedComponents.entrySet().stream().filter(entry -> entry.getValue() != null && ((Property)entry.getValue()).getValue() != null).map(entry -> (Generic)((Generic)entry.getKey()).setInstance((Serializable)((Property)entry.getValue()).getValue(), (DefaultGeneric[])new Generic[0])).filter(gen -> gen != null).toArray(Generic[]::new);
                    if (selectedGenerics.length + 1 == model.getGeneric().getComponents().size()) {
                        selectedComponents.values().stream().forEach((? super T sel) -> sel.setValue(null));
                        try {
                            model.getGenerics()[1].setHolder((DefaultGeneric)model.getGeneric(), null, (DefaultGeneric[])selectedGenerics);
                        }
                        catch (RollbackException e) {
                            logger.error("RollbackException, error occurred while trying to setHolder on {}." + model.getGenerics()[1], (Throwable)e);
                        }
                    }
                };
                selectedComponents.values().forEach((? super T component) -> component.addListener(listener));
            });
        }
    }

    @Style.Styles(value={@Style(name="flex", value="1"), @Style(name="width", value="100%")})
    public static class DirectRelationComponentEditor
    extends InputWithDatalist.InputTextEditorWithDatalist
    implements ComponentsDefaults {
        @Override
        public void init() {
            super.init();
            this.addPostfixBinding(model -> {
                Map<Generic, Property<Serializable>> selectedComponents = this.getComponentsMap((Context)model);
                if (selectedComponents != null) {
                    selectedComponents.put(model.getGeneric(), this.find(InputTextWithConversion.class).getConvertedValueProperty((Context)model));
                }
            });
        }
    }

    @Style.Styles(value={@Style(path={InstancesTable.ValueComponents.class}, name="flex", value="1 0 auto"), @Style(name="flex-wrap", value="wrap"), @Style(name="overflow", value="auto")})
    @Children.ChildrenMult(value={@Children(value={ValueComponentsEditor.class, HolderAdder.class}), @Children(path={HolderAdder.class, Composite.Header.class}, value={HolderAdderInput.class, BooleanHolderAdderInput.class})})
    @ForEach(path={HolderAdder.class}, value=ForEachExtractor.NO_FOR_EACH.class)
    @SelectContext(path={HolderAdder.class}, value=OptionalContextSelector.HOLDER_ADDITION_ENABLED_SELECTOR.class)
    @Style.FlexDirectionStyle(value=FlexDirection.COLUMN)
    public static class HoldersEditor
    extends InstancesTable.Holders {
    }

    @Style.Styles(value={@Style(path={Composite.Header.class, InputTextWithConversion.InputTextEditorWithConversion.class}, name="flex", value="1"), @Style(path={Composite.Header.class, InputTextWithConversion.InputTextEditorWithConversion.class}, name="width", value="100%")})
    @Children.ChildrenMult(value={@Children(value={Composite.Content.class, Composite.Header.class, ActionLink.class}), @Children(path={Composite.Header.class}, value={InputTextWithConversion.InputTextEditorWithConversion.class, CheckBoxWithValue.CheckBoxEditor.class}), @Children(path={Composite.Content.class}, value={DirectRelationComponentEditor.class})})
    @SelectContext(path={ActionLink.class}, value=OptionalContextSelector.REMOVABLE_HOLDER_SELECTOR.class)
    @Select.Selects(value={@Select(path={Composite.Header.class, InputTextWithConversion.InputTextEditorWithConversion.class}, value=GenericSelector.INSTANCE_LABEL_DISPLAYER.class), @Select(path={Composite.Header.class, CheckBoxWithValue.CheckBoxEditor.class}, value=GenericSelector.INSTANCE_CHECK_BOX_DISPLAYER.class)})
    @SetText(path={ActionLink.class}, value={"\u00d7"})
    @BindAction(path={ActionLink.class}, value={ContextAction.REMOVE.class})
    public static class ValueComponentsEditor
    extends InstancesTable.ValueComponents
    implements ComponentsDefaults {
    }

    @Style.Styles(value={@Style(path={InstancesTable.ValueComponents.class}, name="flex", value="1 0 auto"), @Style(name="flex-wrap", value="wrap"), @Style(name="overflow", value="auto")})
    @Children(value={PasswordEditor.class, PasswordAdder.class})
    @ForEach(path={PasswordEditor.class}, value=ForEachExtractor.HOLDERS.class)
    @SelectContext(path={PasswordAdder.class}, value=OptionalContextSelector.HOLDER_ADDITION_ENABLED_SELECTOR.class)
    @Style.FlexDirectionStyle(value=FlexDirection.COLUMN)
    public static class PasswordHoldersEditor
    extends FlexDiv
    implements PasswordDefaults {
        @Override
        public void init() {
            this.createSaltProperty();
        }
    }

    @Children(value={HtmlTag.HtmlLabel.class, InputTextWithConversion.PasswordInput.class, HtmlTag.HtmlLabel.class, InputTextWithConversion.PasswordInput.class, HtmlTag.HtmlSpan.class})
    @SetText.SetTexts(value={@SetText(path={HtmlTag.HtmlLabel.class}, pos={0}, value={"Enter new password:"}), @SetText(path={HtmlTag.HtmlLabel.class}, pos={1}, value={"Confirm password:"}), @SetText(path={HtmlTag.HtmlSpan.class}, value={"These passwords don\u2019t match. Try again."})})
    @Style.Styles(value={@Style(path={HtmlTag.HtmlSpan.class}, name="color", value="darkred"), @Style(path={HtmlTag.HtmlSpan.class}, name="display", value="none")})
    public static class PasswordAdder
    extends FlexDiv
    implements PasswordDefaults,
    ConvertedValueDefaults {
        @Override
        public void init() {
            this.createConvertedValueProperty();
            this.addConvertedValueChangeListener((context, nva) -> {
                if (nva != null) {
                    Generic passwordHash = (Generic)context.getGenerics()[1].addHolder((DefaultGeneric)context.getGeneric(), nva, (DefaultGeneric[])new Generic[0]);
                    passwordHash.setHolder((DefaultGeneric)context.find(User.Salt.class), (Serializable)this.getSaltProperty((Context)context).getValue(), (DefaultGeneric[])new Generic[0]);
                }
            });
            this.find(InputTextWithConversion.PasswordInput.class).addConvertedValueChangeListener((context, nva) -> {
                if (nva != null && Arrays.equals((byte[])nva, (byte[])this.find(InputTextWithConversion.PasswordInput.class, 1).getConvertedValueProperty((Context)context).getValue())) {
                    this.find(HtmlTag.HtmlSpan.class).addStyle((Context)context, "display", "none");
                    this.getConvertedValueProperty((Context)context).setValue(nva);
                } else {
                    this.find(HtmlTag.HtmlSpan.class).addStyle((Context)context, "display", "inline");
                }
            });
            this.find(InputTextWithConversion.PasswordInput.class, 1).addConvertedValueChangeListener((context, nva) -> {
                if (nva != null && Arrays.equals((byte[])nva, (byte[])this.find(InputTextWithConversion.PasswordInput.class, 0).getConvertedValueProperty((Context)context).getValue())) {
                    this.find(HtmlTag.HtmlSpan.class).addStyle((Context)context, "display", "none");
                    this.getConvertedValueProperty((Context)context).setValue(nva);
                } else {
                    this.find(HtmlTag.HtmlSpan.class).addStyle((Context)context, "display", "inline");
                }
            });
        }
    }

    @SetText(value={"OK"})
    public static class ValidateButton
    extends HtmlTag.HtmlButton
    implements PasswordDefaults,
    UserRoleDefaults {
        @Override
        public void init() {
            this.bindAction(context -> {
                HtmlTag.HtmlInputText oldPassword = this.getParent().find(HtmlTag.HtmlInputText.class);
                HtmlTag.HtmlInputText passwordInput = this.getParent().find(HtmlTag.HtmlInputText.class, 1);
                HtmlTag.HtmlInputText confirmPassword = this.getParent().find(HtmlTag.HtmlInputText.class, 2);
                HtmlTag.HtmlSpan invalidPassword = this.getParent().find(HtmlTag.HtmlSpan.class, 1);
                HtmlTag.HtmlSpan invalidConfirmPassword = this.getParent().find(HtmlTag.HtmlSpan.class);
                if (Arrays.equals((byte[])context.getGeneric().getValue(), EncryptionUtils.getEncryptedPassword((String)oldPassword.getDomNodeAttributes((Context)context).get((Object)"value"), (byte[])this.getSaltProperty((Context)context).getValue()))) {
                    String psw1 = (String)passwordInput.getDomNodeAttributes((Context)context).get((Object)"value");
                    String psw2 = (String)confirmPassword.getDomNodeAttributes((Context)context).get((Object)"value");
                    if (psw1 != null && psw1.equals(psw2)) {
                        invalidConfirmPassword.addStyle((Context)context, "display", "none");
                        invalidPassword.addStyle((Context)context, "display", "none");
                        context.getGeneric().updateValue((Serializable)EncryptionUtils.getEncryptedPassword(psw1, (byte[])this.getSaltProperty((Context)context).getValue()));
                    } else {
                        invalidConfirmPassword.addStyle((Context)context, "display", "none");
                    }
                } else {
                    invalidPassword.addStyle((Context)context, "display", "inline");
                }
            });
        }
    }

    @Children(value={HtmlTag.HtmlLabel.class, HtmlTag.HtmlInputText.class, HtmlTag.HtmlLabel.class, HtmlTag.HtmlInputText.class, HtmlTag.HtmlLabel.class, HtmlTag.HtmlInputText.class, HtmlTag.HtmlSpan.class, HtmlTag.HtmlSpan.class, ValidateButton.class})
    @SetText.SetTexts(value={@SetText(path={HtmlTag.HtmlLabel.class}, pos={0}, value={"Enter old password:"}), @SetText(path={HtmlTag.HtmlLabel.class}, pos={1}, value={"Enter new password:"}), @SetText(path={HtmlTag.HtmlLabel.class}, pos={2}, value={"Confirm password:"}), @SetText(path={HtmlTag.HtmlSpan.class}, pos={0}, value={"These passwords don\u2019t match. Try again."}), @SetText(path={HtmlTag.HtmlSpan.class}, pos={1}, value={"Old password incorrect."})})
    @Style.Styles(value={@Style(path={HtmlTag.HtmlSpan.class}, name="color", value="darkred"), @Style(path={HtmlTag.HtmlSpan.class}, name="display", value="none")})
    @Attribute.Attributes(value={@Attribute(path={HtmlTag.HtmlInputText.class}, pos={0}, name="type", value="password"), @Attribute(path={HtmlTag.HtmlInputText.class}, pos={1}, name="type", value="password"), @Attribute(path={HtmlTag.HtmlInputText.class}, pos={2}, name="type", value="password")})
    public static class PasswordEditorContent
    extends FlexDiv {
    }

    @Children.ChildrenMult(value={@Children(value={Modal.ModalWithDisplay.class, HtmlTag.HtmlHyperLink.class}), @Children(path={Modal.ModalWithDisplay.class, FlexDiv.class}, value={PasswordEditorContent.class, HtmlTag.HtmlHyperLink.class})})
    @SetText(path={HtmlTag.HtmlHyperLink.class}, value={"Change password"})
    @BindAction(path={HtmlTag.HtmlHyperLink.class}, value={ContextAction.MODAL_DISPLAY_FLEX.class})
    public static class PasswordEditor
    extends FlexDiv
    implements PasswordDefaults {
        @Override
        public void init() {
            this.addPrefixBinding(context -> {
                Property<byte[]> saltProperty = this.getSaltProperty((Context)context);
                if (saltProperty.getValue() == null) {
                    saltProperty.setValue((Object)((byte[])((Generic)context.find(User.Salt.class).getInstance((DefaultGeneric[])new Generic[]{context.getGeneric()})).getValue()));
                }
            });
        }
    }

    @Style.Styles(value={@Style(name="float", value="left"), @Style(name="vertical-align", value="middle"), @Style(name="margin", value="4px")})
    public static class Checkbox
    extends CheckBoxWithValue {
        @Override
        public void init() {
            this.initValueProperty(context -> context.getGenerics()[2].getLink((DefaultGeneric)context.getGenerics()[1], (DefaultGeneric[])new Generic[]{context.getGeneric()}) != null);
            this.addPrefixBinding(context -> {
                Observable observableLink = context.getGenerics()[2].getObservableLink((DefaultGeneric)context.getGenerics()[1], (DefaultGeneric[])new Generic[]{context.getGeneric()});
                Observable exists = observableLink.map(opt -> opt.isPresent());
                context.getHtmlDomNode(this).getDisposables().add(exists.subscribe(bool -> {
                    if (!context.isDestroyed()) {
                        this.getConvertedValueProperty((Context)context).setValue(bool);
                    }
                }));
            });
            this.addConvertedValueChangeListener((context, nva) -> {
                Generic link;
                if (Boolean.TRUE.equals(nva)) {
                    context.getGenerics()[2].setHolder((DefaultGeneric)context.getGenerics()[1], null, (DefaultGeneric[])new Generic[]{context.getGeneric()});
                }
                if (Boolean.FALSE.equals(nva) && (link = (Generic)context.getGenerics()[2].getLink((DefaultGeneric)context.getGenerics()[1], (DefaultGeneric[])new Generic[]{context.getGeneric()})) != null) {
                    link.remove();
                }
            });
        }
    }

    @Style.Styles(value={@Style(name="flex", value="1 0 auto"), @Style(name="justify-content", value="center"), @Style(name="align-items", value="center"), @Style(name="text-align", value="center")})
    @Style.GenericValueBackgroundColor(value="#e5ed00")
    @Children(value={Checkbox.class})
    @BindText
    public static class CheckboxLabel
    extends HtmlTag.HtmlLabel {
    }

    @Children(value={CheckboxLabel.class})
    @ForEach(path={CheckboxLabel.class}, value=ForEachExtractor.SUBINSTANCES_OF_LINK_COMPONENT.class)
    @Style.Styles(value={@Style(name="flex-wrap", value="wrap"), @Style(name="overflow", value="auto"), @Style(name="margin-right", value="1px"), @Style(name="margin-bottom", value="1px"), @Style(name="flex", value="1 1 0%")})
    public static class MultiCheckbox
    extends FlexDiv {
    }

    @Children(value={PasswordHoldersEditor.class, HoldersEditor.class, MultiCheckbox.class})
    @ForEach(value=ForEachExtractor.ATTRIBUTES_OF_INSTANCES.class)
    @Select.Selects(value={@Select(path={PasswordHoldersEditor.class}, value=GenericSelector.PASSWORD_ATTRIBUTE_SELECTOR.class), @Select(path={HoldersEditor.class}, value=GenericSelector.NON_MULTICHECKBOX_INSTANCE_SELECTOR.class), @Select(path={MultiCheckbox.class}, value=GenericSelector.MULTICHECKBOX_INSTANCE_SELECTOR.class)})
    public static class AttributeContent
    extends Composite.Content {
    }

    public static class AttributeEdition
    extends Composite {
    }

    public static class InstanceName
    extends Composite {
    }
}

