/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor.annotations;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.function.BiConsumer;
import org.genericsystem.reactor.Tag;
import org.genericsystem.reactor.annotations.BindSelection;
import org.genericsystem.reactor.annotations.Process;
import org.genericsystem.reactor.contextproperties.StepperDefaults;
import org.genericsystem.reactor.gscomponents.TagImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@Repeatable(value=Steppers.class)
@Process(value=Stepper2Processor.class)
public @interface Stepper2 {
    public Class<? extends TagImpl>[] path() default {};

    public int[] pos() default {};

    public Class<? extends TagImpl> switchClass();

    public int switchClassPos() default 0;

    public Class<? extends TagImpl> headerClass();

    public int headerClassPos() default 0;

    public static class Stepper2Processor
    implements BiConsumer<Annotation, Tag> {
        private static final Logger log = LoggerFactory.getLogger(BindSelection.BindSelectionProcessor.class);

        @Override
        public void accept(Annotation annotation, Tag tag) {
            if (StepperDefaults.class.isAssignableFrom(tag.getClass())) {
                Stepper2 stepperAnn = (Stepper2)annotation;
                tag.stepper(tag.find(stepperAnn.switchClass(), stepperAnn.switchClassPos()), tag.find(stepperAnn.headerClass(), stepperAnn.headerClassPos()));
            } else {
                log.warn("Switch is applicable only to tags implementing SwitchDefaults. Applied to class: {}.", (Object)tag.getClass().getName());
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Steppers {
        public Stepper2[] value();
    }
}

