/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.HtmlDomNode;
import org.genericsystem.reactor.RootTag;

public class RootHtmlDomNode
extends HtmlDomNode {
    private final Map<String, HtmlDomNode> nodeById = new HashMap<String, HtmlDomNode>();
    private final HtmlDomNode.Sender send;
    private final String rootId;

    public RootHtmlDomNode(Context rootModelContext, RootTag rootTag, String rootId, HtmlDomNode.Sender send) {
        super(null, rootModelContext, rootTag);
        this.rootId = rootId;
        this.send = send;
        this.sendAdd(0);
        this.init(0);
    }

    @Override
    public HtmlDomNode.Sender getSender() {
        return this.send;
    }

    @Override
    protected RootHtmlDomNode getRootHtmlDomNode() {
        return this;
    }

    @Override
    public String getParentId() {
        return this.rootId;
    }

    private Map<String, HtmlDomNode> getMap() {
        return this.nodeById;
    }

    public HtmlDomNode getNodeById(String id) {
        return this.getMap().get(id);
    }

    public void add(String id, HtmlDomNode domNode) {
        this.getMap().put(id, domNode);
    }

    public void remove(String id) {
        this.getMap().remove(id);
    }

    public String header() {
        String header = "";
        String appName = this.getTag().getClass().getSimpleName().toLowerCase();
        header = "<!DOCTYPE html>\n";
        header = header + "<html>\n";
        header = header + "<head>\n";
        header = header + "<meta charset=\"UTF-8\" name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n";
        header = header + "<LINK rel=stylesheet type=\"text/css\" href=\"" + appName + ".css\"/>\n";
        header = header + "<LINK rel=stylesheet type=\"text/css\" href=\"reactor.css\"/>\n";
        header = header + "<script>\n";
        header = header + "var serviceLocation = \"ws://\" + document.location.host + \"\";\n";
        header = header + "</script>\n";
        header = header + "<script type=\"text/javascript\" src=\"" + appName + ".js\"></script>\n";
        header = header + "</head>\n";
        header = header + "<body onload=\"connect();\" id=\"root\">\n";
        return header;
    }

    public String footer() {
        return "</body>\n</html>\n";
    }

    public void toHtmlFile(String sourceCode, String extension, String path) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(path + "index." + extension));
            writer.write(sourceCode);
            writer.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

