/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor.extended;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.collections.transformation.SortedList;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.api.core.TagAnnotation;
import org.genericsystem.api.core.annotations.Components;
import org.genericsystem.api.core.annotations.Dependencies;
import org.genericsystem.api.core.annotations.InstanceClass;
import org.genericsystem.api.core.annotations.Meta;
import org.genericsystem.api.core.annotations.SystemGeneric;
import org.genericsystem.api.core.annotations.constraints.InstanceValueClassConstraint;
import org.genericsystem.api.core.annotations.constraints.NoInheritance;
import org.genericsystem.api.core.annotations.constraints.PropertyConstraint;
import org.genericsystem.api.core.annotations.value.ClassGenericValue;
import org.genericsystem.common.Generic;
import org.genericsystem.common.Root;
import org.genericsystem.defaults.DefaultGeneric;
import org.genericsystem.reactor.AnnotationsManager;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.HtmlDomNode;
import org.genericsystem.reactor.RootHtmlDomNode;
import org.genericsystem.reactor.Tag;
import org.genericsystem.reactor.TagNode;
import org.genericsystem.reactor.annotations.Children;
import org.genericsystem.reactor.extended.ExtendedAnnotationsManager;
import org.genericsystem.reactor.gscomponents.RootTagImpl;
import org.genericsystem.reactor.gscomponents.TagImpl;

public class ExtendedRootTag
extends RootTagImpl {
    private final Root engine;
    private final Map<Class<?>, GTag> storedClasses = new HashMap();
    private final ListChangeListener<? super GTagAnnotationContent> listener = c -> {
        while (c.next()) {
            if (c.wasRemoved()) {
                this.updateApplyingAnnotations(c.getRemoved().stream(), (annotations, value) -> annotations.remove(value));
            }
            if (!c.wasAdded()) continue;
            this.updateApplyingAnnotations(c.getAddedSubList().stream(), (annotations, value) -> annotations.add(value));
        }
    };

    private void updateApplyingAnnotations(Stream<? extends GTagAnnotationContent> streamToConsum, BiConsumer<ObservableList<GenericAnnotationWithContent>, GenericAnnotationWithContent> action) {
        streamToConsum.forEach((? super T valueGeneric) -> {
            GTagAnnotation gTagAnnotation = valueGeneric.getBaseComponent();
            AnnotationClassName key = new AnnotationClassName(gTagAnnotation.getValue().getAnnotationClass(), gTagAnnotation.getValue().getName());
            GenericAnnotationWithContent value = new GenericAnnotationWithContent(gTagAnnotation, (GTagAnnotationContent)valueGeneric);
            TagAnnotation tagAnnotation = gTagAnnotation.getValue();
            LinkedList path = new LinkedList(Stream.of(tagAnnotation.getPath()).collect(Collectors.toList()));
            path.addFirst((Class<?>)gTagAnnotation.getBaseComponent().getValue());
            LinkedList pos = Arrays.stream(tagAnnotation.getPos()).boxed().collect(Collectors.toCollection(LinkedList::new));
            if (!pos.isEmpty()) {
                pos.addFirst(-1);
            }
            Set<Tag> concernedTags = this.searchTags(this, path, pos);
            concernedTags.forEach((? super T tag) -> action.accept((ObservableList<GenericAnnotationWithContent>)((GenericTagNode)tag.getTagNode()).tagAnnotations.get(key), value));
        });
    }

    private Set<Tag> searchTags(Tag subTree, LinkedList<Class<?>> path, LinkedList<Integer> pos) {
        HashSet<Tag> foundTags = new HashSet<Tag>();
        foundTags.addAll(this.searchTagsFromFirst(subTree, path, pos));
        subTree.getObservableChildren().forEach(child -> foundTags.addAll(this.searchTags((Tag)child, path, pos)));
        return foundTags;
    }

    private Set<Tag> searchTagsFromFirst(Tag firstTag, LinkedList<Class<?>> path, LinkedList<Integer> pos) {
        if (path.isEmpty()) {
            return new HashSet<Tag>();
        }
        HashSet<Tag> foundTags = new HashSet<Tag>();
        if (path.peek().isAssignableFrom(firstTag.getClass()) && (pos.isEmpty() || pos.peek() == -1 || firstTag.getParent() != null && AnnotationsManager.position(firstTag, path.peek()) == pos.peek())) {
            if (path.size() == 1) {
                foundTags.add(firstTag);
            } else {
                firstTag.getObservableChildren().forEach(child -> foundTags.addAll(this.searchTagsFromFirst((Tag)child, new LinkedList(path.subList(1, path.size())), pos.isEmpty() ? pos : new LinkedList(pos.subList(1, pos.size())))));
            }
        }
        return foundTags;
    }

    public ExtendedRootTag(Root engine) {
        this.engine = engine;
        this.annotationsManager = new ExtendedAnnotationsManager(this.getClass());
        this.storedClasses.put(TagImpl.class, (GTag)engine.find(GTag.class));
        this.storeClass(this.getClass());
        this.setTagNode(this.buildTagNode(this));
        this.processAnnotations(this);
        this.init();
    }

    @Override
    protected void initRoot() {
    }

    @Override
    public RootHtmlDomNode init(Context rootModelContext, String rootId, HtmlDomNode.Sender send) {
        return new RootHtmlDomNode(rootModelContext, this, rootId, send){
            private final ObservableList<GTagAnnotationContent> annotationContentInstances;
            {
                this.annotationContentInstances = ExtendedRootTag.this.engine.find(TagType.TagAnnotationContentAttribute.class).getSubInstances().toObservableList();
                this.annotationContentInstances.addListener((ListChangeListener)new WeakListChangeListener(ExtendedRootTag.this.listener));
            }
        };
    }

    @Override
    public void initDomNode(HtmlDomNode htmlDomNode) {
        ((GenericTagNode)htmlDomNode.getTag().getTagNode()).getSortedAnnotationsLists().entrySet().forEach((? super T entry) -> ((SortedList)entry.getValue()).addListener(this.getApplyingAnnotationsListener(htmlDomNode.getTag(), htmlDomNode.getModelContext(), ((AnnotationClassName)entry.getKey()).getAnnotationClass())));
    }

    ListChangeListener<? super GenericAnnotationWithContent> getApplyingAnnotationsListener(Tag tag, Context context, Class<? extends Annotation> annotationClass) {
        return c -> {
            Map<Class<? extends Annotation>, ExtendedAnnotationsManager.IGenericAnnotationProcessor> processors;
            if (!context.isDestroyed() && (processors = ((ExtendedAnnotationsManager)this.annotationsManager).getProcessors()).containsKey(annotationClass)) {
                while (c.next()) {
                    if (c.wasAdded() && c.getFrom() == 0) {
                        if (c.getList().size() > c.getAddedSize()) {
                            GenericAnnotationWithContent formerApplyingAnnotation = (GenericAnnotationWithContent)c.getList().get(c.getAddedSize());
                            processors.get(annotationClass).onRemove(tag, context, formerApplyingAnnotation.getgTagAnnotation(), formerApplyingAnnotation.getAnnotationContent());
                        }
                        processors.get(annotationClass).onAdd(tag, context, ((GenericAnnotationWithContent)c.getAddedSubList().get(0)).getgTagAnnotation(), ((GenericAnnotationWithContent)c.getAddedSubList().get(0)).getAnnotationContent());
                    }
                    if (!c.wasRemoved() || c.getFrom() != 0) continue;
                    processors.get(annotationClass).onRemove(tag, context, ((GenericAnnotationWithContent)c.getRemoved().get(0)).getgTagAnnotation(), ((GenericAnnotationWithContent)c.getRemoved().get(0)).getAnnotationContent());
                    if (c.getList().isEmpty()) continue;
                    GenericAnnotationWithContent newApplyingAnnotation = (GenericAnnotationWithContent)c.getList().get(0);
                    processors.get(annotationClass).onAdd(tag, context, newApplyingAnnotation.getgTagAnnotation(), newApplyingAnnotation.getAnnotationContent());
                }
            }
        };
    }

    ListChangeListener<? super GenericAnnotationWithContent> getApplyingAnnotationsListener(Tag tag, Class<? extends Annotation> annotationClass) {
        return c -> {
            Map<Class<? extends Annotation>, ExtendedAnnotationsManager.IGenericAnnotationProcessor> processors = ((ExtendedAnnotationsManager)this.annotationsManager).getProcessors();
            if (processors.containsKey(annotationClass)) {
                while (c.next()) {
                    if (c.wasAdded() && c.getFrom() == 0) {
                        if (c.getList().size() > c.getAddedSize()) {
                            GenericAnnotationWithContent formerApplyingAnnotation = (GenericAnnotationWithContent)c.getList().get(c.getAddedSize());
                            processors.get(annotationClass).onRemove(tag, formerApplyingAnnotation.getgTagAnnotation(), formerApplyingAnnotation.getAnnotationContent());
                        }
                        processors.get(annotationClass).onAdd(tag, ((GenericAnnotationWithContent)c.getAddedSubList().get(0)).getgTagAnnotation(), ((GenericAnnotationWithContent)c.getAddedSubList().get(0)).getAnnotationContent());
                    }
                    if (!c.wasRemoved() || c.getFrom() != 0) continue;
                    processors.get(annotationClass).onRemove(tag, ((GenericAnnotationWithContent)c.getRemoved().get(0)).getgTagAnnotation(), ((GenericAnnotationWithContent)c.getRemoved().get(0)).getAnnotationContent());
                    if (c.getList().isEmpty()) continue;
                    GenericAnnotationWithContent newApplyingAnnotation = (GenericAnnotationWithContent)c.getList().get(0);
                    processors.get(annotationClass).onAdd(tag, newApplyingAnnotation.getgTagAnnotation(), newApplyingAnnotation.getAnnotationContent());
                }
            }
        };
    }

    public Root getEngine() {
        return this.engine;
    }

    @Override
    public TagNode buildTagNode(Tag tag) {
        return new GenericTagNode(tag);
    }

    private GTag storeClass(Class<?> clazz) {
        if (!TagImpl.class.isAssignableFrom(clazz)) {
            return (GTag)this.getEngine().find(GTag.class);
        }
        GTag result = this.storedClasses.get(clazz);
        if (result != null) {
            return result;
        }
        GTag parentGeneric = this.storeClass(clazz.getSuperclass());
        result = (GTag)parentGeneric.getMeta().setInstance((DefaultGeneric)parentGeneric, clazz, (DefaultGeneric[])new Generic[0]);
        this.storedClasses.put(clazz, result);
        for (Children childrenAnnotation : (Children[])clazz.getAnnotationsByType(Children.class)) {
            for (Class<? extends TagImpl> childClass : childrenAnnotation.value()) {
                this.storeClass(childClass);
            }
        }
        for (Class clazz2 : ((ExtendedAnnotationsManager)this.annotationsManager).getProcessors().keySet()) {
            for (Annotation annotation : clazz.getAnnotationsByType(clazz2)) {
                ((ExtendedAnnotationsManager)this.annotationsManager).getProcessors().get(clazz2).setAnnotation(result, annotation);
            }
        }
        this.getEngine().getCurrentCache().flush();
        return result;
    }

    public static interface GTagAnnotationContent
    extends Generic {
        default public GTagAnnotation getBaseComponent() {
            return (GTagAnnotation)super.getBaseComponent();
        }

        default public Stream<Class<?>> getClassesStream() {
            return this.getContentJSonArray().stream().map(className -> {
                try {
                    return Class.forName((String)className);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Class " + className + " not found");
                }
            });
        }

        default public String getValue() {
            return (String)((Object)super.getValue());
        }

        default public JsonObject getJsonValue() {
            return new JsonObject(this.getValue());
        }

        default public JsonArray getContentJSonArray() {
            return this.getJsonValue().getJsonArray("value");
        }

        default public String getContentValue() {
            return this.getJsonValue().getString("value");
        }

        default public Class<?> getClassContent() {
            try {
                return Class.forName(this.getContentValue());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Class " + this.getContentValue() + " not found");
            }
        }

        default public Class<?>[] getClassArrayContent() {
            return (Class[])this.getClassesStream().toArray(Class[]::new);
        }

        default public String[] getStringArrayContent() {
            return (String[])this.getContentJSonArray().stream().toArray(String[]::new);
        }
    }

    public static interface GTagAnnotation
    extends Generic {
        default public GTag getBaseComponent() {
            return (GTag)super.getBaseComponent();
        }

        default public TagAnnotation getValue() {
            return (TagAnnotation)super.getValue();
        }

        default public GTagAnnotationContent getContent() {
            return (GTagAnnotationContent)this.getHolder((DefaultGeneric)this.getRoot().find(TagType.TagAnnotationContentAttribute.class), (DefaultGeneric[])new Generic[0]);
        }
    }

    @SystemGeneric
    @Meta(value=TagType.class)
    @ClassGenericValue(value=TagImpl.class)
    public static interface GTag
    extends Generic {
        default public Class<?> getValue() {
            return (Class)super.getValue();
        }

        default public Snapshot<GTagAnnotation> getAnnotations() {
            return this.getHolders((DefaultGeneric)this.getRoot().find(TagType.TagAnnotationAttribute.class));
        }

        default public GTagAnnotation setAnnotation(Class<? extends Annotation> annotationClass, String name, String value, Class<?>[] path, int[] positions) {
            GTagAnnotation styleAnnotation = (GTagAnnotation)this.setHolder((DefaultGeneric)this.getRoot().find(TagType.TagAnnotationAttribute.class), (Serializable)new TagAnnotation(annotationClass, (Class[])path, positions, name), (DefaultGeneric[])new Generic[0]);
            styleAnnotation.setHolder((DefaultGeneric)this.getRoot().find(TagType.TagAnnotationContentAttribute.class), (Serializable)((Object)new JsonObject().put("value", value).encodePrettily()), (DefaultGeneric[])new Generic[0]);
            return styleAnnotation;
        }

        default public void setArrayValueAnnotation(Class<? extends Annotation> annotationClass, String name, Object[] value, Class<?>[] path, int[] positions) {
            GTagAnnotation gTagAnnotation = (GTagAnnotation)this.setHolder((DefaultGeneric)this.getRoot().find(TagType.TagAnnotationAttribute.class), (Serializable)new TagAnnotation(annotationClass, (Class[])path, positions), (DefaultGeneric[])new Generic[0]);
            gTagAnnotation.setHolder((DefaultGeneric)this.getRoot().find(TagType.TagAnnotationContentAttribute.class), (Serializable)((Object)new JsonObject().put("value", new JsonArray(Arrays.asList(value))).encodePrettily()), (DefaultGeneric[])new Generic[0]);
        }
    }

    @SystemGeneric
    @InstanceClass(value=GTag.class)
    @Dependencies(value={TagAnnotationAttribute.class})
    @InstanceValueClassConstraint(value=Class.class)
    public static interface TagType
    extends Generic {

        @SystemGeneric
        @Components(value={TagAnnotationAttribute.class})
        @InstanceValueClassConstraint(value=String.class)
        @PropertyConstraint
        @NoInheritance
        @InstanceClass(value=GTagAnnotationContent.class)
        public static interface TagAnnotationContentAttribute
        extends Generic {
        }

        @SystemGeneric
        @Components(value={TagType.class})
        @InstanceValueClassConstraint(value=TagAnnotation.class)
        @Dependencies(value={TagAnnotationContentAttribute.class})
        @InstanceClass(value=GTagAnnotation.class)
        public static interface TagAnnotationAttribute
        extends Generic {
        }
    }

    class GenericTagNode
    extends RootTagImpl.SimpleTagNode {
        private Map<AnnotationClassName, SortedList<GenericAnnotationWithContent>> sortedAnnotationsLists = new TreeMap<AnnotationClassName, SortedList<GenericAnnotationWithContent>>((an1, an2) -> {
            List processors = ((ExtendedAnnotationsManager)ExtendedRootTag.this.annotationsManager).getProcessors().keySet().stream().collect(Collectors.toList());
            Class<? extends Annotation> class1 = an1.getAnnotationClass();
            Class<? extends Annotation> class2 = an2.getAnnotationClass();
            if (an1.equals(an2)) {
                return 0;
            }
            return class1.equals(class2) ? an1.getName().compareTo(an2.getName()) : Integer.compare(processors.indexOf(class1), processors.indexOf(class2));
        });
        private Map<AnnotationClassName, ObservableList<GenericAnnotationWithContent>> tagAnnotations = new HashMap<AnnotationClassName, ObservableList<GenericAnnotationWithContent>>(){
            private static final long serialVersionUID = -3404232263162064472L;

            @Override
            public ObservableList<GenericAnnotationWithContent> get(Object key) {
                ObservableList result = (ObservableList)super.get(key);
                if (result == null && key instanceof AnnotationClassName) {
                    result = FXCollections.observableArrayList();
                    SortedList sortedList = new SortedList(result, (Comparator)new Comparator<GenericAnnotationWithContent>(){

                        @Override
                        public int compare(GenericAnnotationWithContent o1, GenericAnnotationWithContent o2) {
                            Class[] secondPath;
                            Class[] firstPath = o1.getgTagAnnotation().getValue().getPath();
                            return firstPath.length < (secondPath = o2.getgTagAnnotation().getValue().getPath()).length || firstPath.length == secondPath.length && AnnotationsManager.isAssignableFrom(Arrays.asList(firstPath), Arrays.asList(secondPath)) ? 1 : -1;
                        }
                    });
                    GenericTagNode.this.sortedAnnotationsLists.put((AnnotationClassName)key, sortedList);
                    this.put((AnnotationClassName)key, result);
                }
                return result;
            }
        };

        public Map<AnnotationClassName, ObservableList<GenericAnnotationWithContent>> getTagAnnotations() {
            return this.tagAnnotations;
        }

        public Map<AnnotationClassName, SortedList<GenericAnnotationWithContent>> getSortedAnnotationsLists() {
            return this.sortedAnnotationsLists;
        }

        public GenericTagNode(Tag tag) {
            ArrayDeque classesToResult = new ArrayDeque();
            for (Tag current = tag; current != null; current = current.getParent()) {
                Set<GTagAnnotation> annotationsFound = this.selectAnnotations(current.getClass(), classesToResult, tag);
                annotationsFound.forEach(annotation -> this.tagAnnotations.get(new AnnotationClassName(annotation.getValue().getAnnotationClass(), annotation.getValue().getName())).add((Object)new GenericAnnotationWithContent((GTagAnnotation)annotation, annotation.getContent())));
                classesToResult.push(current.getClass());
            }
        }

        private Set<GTagAnnotation> selectAnnotations(Class<?> annotatedClass, Deque<Class<?>> classesToResult, Tag tag) {
            HashSet<GTagAnnotation> annotationsFound = new HashSet<GTagAnnotation>();
            for (GTagAnnotation annotation : ((GTag)ExtendedRootTag.this.storedClasses.get(annotatedClass)).getAnnotations()) {
                Class[] path = annotation.getValue().getPath();
                int[] pos = annotation.getValue().getPos();
                if (pos.length != 0 && pos.length != path.length) {
                    throw new IllegalStateException("The annotation " + annotation.getValue().getAnnotationClass().getSimpleName() + " contains a path and an array of class positions of different lengths. path: " + Arrays.asList(path).stream().map(c -> c.getSimpleName()).collect(Collectors.toList()) + ", positions: " + Arrays.stream(pos).boxed().collect(Collectors.toList()) + " found on class " + annotatedClass.getSimpleName());
                }
                if (!AnnotationsManager.isAssignableFrom(Arrays.asList(path), new ArrayList(classesToResult)) || !AnnotationsManager.posMatches(pos, path, tag)) continue;
                annotationsFound.add(annotation);
            }
            return annotationsFound;
        }
    }

    class GenericAnnotationWithContent {
        private GTagAnnotation gTagAnnotation;
        private GTagAnnotationContent annotationContent;

        public GenericAnnotationWithContent(GTagAnnotation gTagAnnotation, GTagAnnotationContent annotationContent) {
            this.gTagAnnotation = gTagAnnotation;
            this.annotationContent = annotationContent;
        }

        public GTagAnnotation getgTagAnnotation() {
            return this.gTagAnnotation;
        }

        public GTagAnnotationContent getAnnotationContent() {
            return this.annotationContent;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof GenericAnnotationWithContent)) {
                return false;
            }
            GenericAnnotationWithContent other = (GenericAnnotationWithContent)obj;
            return this.gTagAnnotation.equals(other.gTagAnnotation) && Objects.equals(this.annotationContent, other.annotationContent);
        }

        public int hashCode() {
            return this.gTagAnnotation.hashCode();
        }

        public String toString() {
            return "GenericAnnotationValue [gTagAnnotation=" + this.gTagAnnotation + ", annotationContent=" + this.annotationContent + "]";
        }
    }

    static class AnnotationClassName {
        private Class<? extends Annotation> annotationClass;
        private String name;

        public AnnotationClassName(Class<? extends Annotation> annotationClass, String name) {
            this.annotationClass = annotationClass;
            this.name = name;
        }

        public Class<? extends Annotation> getAnnotationClass() {
            return this.annotationClass;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AnnotationClassName)) {
                return false;
            }
            AnnotationClassName other = (AnnotationClassName)obj;
            return this.annotationClass.equals(other.annotationClass) && Objects.equals(this.name, other.name);
        }

        public int hashCode() {
            return this.annotationClass.hashCode();
        }
    }
}

