/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.common.Generic;
import org.genericsystem.defaults.tools.RxJavaHelpers;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.Tag;

public class MetaBinding<BETWEEN> {
    private Function<Context, Observable<Snapshot<BETWEEN>>> betweenChildren;
    private final BiFunction<Context, BETWEEN, Context> modelBuilder;
    private static BiFunction<Context, Generic, Context> MODEL_BUILDER = (model, generic) -> new Context((Context)model, Context.addToGenerics(generic, model.getGenerics()));
    private static BiFunction<Context, Context, Context> MODEL_CLONER = (model, subModel) -> new Context((Context)model, subModel.getGenerics());

    public MetaBinding(Function<Context, Observable<Snapshot<BETWEEN>>> betweenChildren, BiFunction<Context, BETWEEN, Context> modelBuilder) {
        this.betweenChildren = betweenChildren;
        this.modelBuilder = modelBuilder;
    }

    private Observable<Snapshot<Context>> buildChildren(Context context, Tag childTag) {
        return this.betweenChildren.apply(context).map(snapshot -> snapshot.map(g -> this.modelBuilder.apply(context, g)));
    }

    public Observable<IndexedSubContext> buildFilteredChildren(Context context, Tag childTag) {
        return this.buildChildren(context, childTag).doOnNext(unused -> {
            context.getSubContexts(childTag).forEach(subContext -> subContext.destroy());
            context.getSubContexts(childTag).clear();
        }).switchMap(snapshot -> snapshot.getIndexedElements().filter(indexedContext -> indexedContext.getIndex() >= 0).flatMap(indexedSubContext -> this.buildObservableBySubContext((Snapshot<Context>)snapshot, (Context)indexedSubContext.getElement(), childTag, indexedSubContext.getIndex())));
    }

    private Observable<IndexedSubContext> buildObservableBySubContext(Snapshot<Context> snapshot, Context subContext, Tag childTag, int index) {
        return RxJavaHelpers.changesOf(childTag.getObservableSwitchers()).switchMap(list -> list.isEmpty() ? Observable.just((Object)new IndexedSubContext(subContext, true, index)) : Observable.combineLatest((ObservableSource[])((ObservableSource[])list.stream().map(switcher -> (Observable)switcher.apply(subContext, childTag)).toArray(Observable[]::new)), args -> new IndexedSubContext(subContext, Arrays.stream(args).allMatch(v -> Boolean.TRUE.equals(v)), index)).distinctUntilChanged()).mergeWith((ObservableSource)snapshot.getRemovals().filter(context -> context.equals(subContext)).map(context -> new IndexedSubContext((Context)context, false, -1))).takeUntil(indexedContext -> ((IndexedSubContext)indexedContext).getIndex() < 0);
    }

    public Function<Context, Observable<Snapshot<BETWEEN>>> getBetweenChildren() {
        return this.betweenChildren;
    }

    public static MetaBinding<Context> selectMetaBinding(Function<Context, Observable<Snapshot<Context>>> betweenChildren) {
        return new MetaBinding<Context>(betweenChildren, MODEL_CLONER);
    }

    public static MetaBinding<Generic> forEachMetaBinding(Function<Context, Observable<Snapshot<Generic>>> betweenChildren) {
        return new MetaBinding<Generic>(betweenChildren, MODEL_BUILDER);
    }

    public void setBetweenChildren(Function<Context, Observable<Snapshot<BETWEEN>>> betweenChildren) {
        this.betweenChildren = betweenChildren;
    }

    public static class IndexedSubContext {
        private Context context;
        private boolean create;
        private int index;

        public IndexedSubContext(Context context, boolean create, int index) {
            this.context = context;
            this.create = create;
            this.index = index;
        }

        public Context getContext() {
            return this.context;
        }

        public boolean getCreate() {
            return this.create;
        }

        public int getIndex() {
            return this.index;
        }

        public int hashCode() {
            return this.context.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof IndexedSubContext)) {
                return false;
            }
            IndexedSubContext other = (IndexedSubContext)obj;
            return this.create == other.create && this.context.equals(other.context) && this.index == other.index;
        }
    }
}

