/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.quiz.utils;

import io.reactivex.Observable;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import org.genericsystem.common.Generic;
import org.genericsystem.defaults.DefaultGeneric;
import org.genericsystem.defaults.tools.RxJavaHelpers;
import org.genericsystem.quiz.model.Quiz;
import org.genericsystem.quiz.model.ScoreUserQuiz;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.Tag;
import org.genericsystem.reactor.context.TagSwitcher;

public class QuizTagSwitcher {
    public static final String PAGE = "Page";
    public static final String HOME_PAGE = "HomePage";
    public static final String QUESTION_PAGE = "QuestionPage";
    public static final String RESULT_PAGE = "ResultPage";

    public static class RESULT_PAGE
    implements TagSwitcher {
        public Observable<Boolean> apply(Context context, Tag tag) {
            Property pageProperty = tag.getContextProperty(QuizTagSwitcher.PAGE, context);
            return RxJavaHelpers.valuesOf((ObservableValue)pageProperty).map(page -> QuizTagSwitcher.RESULT_PAGE.equals(page));
        }
    }

    public static class QUESTION_PAGE
    implements TagSwitcher {
        public Observable<Boolean> apply(Context context, Tag tag) {
            Property pageProperty = tag.getContextProperty(QuizTagSwitcher.PAGE, context);
            return RxJavaHelpers.valuesOf((ObservableValue)pageProperty).map(page -> QuizTagSwitcher.QUESTION_PAGE.equals(page));
        }
    }

    public static class HOME_PAGE
    implements TagSwitcher {
        public Observable<Boolean> apply(Context context, Tag tag) {
            Property pageProperty = tag.getContextProperty(QuizTagSwitcher.PAGE, context);
            return RxJavaHelpers.valuesOf((ObservableValue)pageProperty).map(page -> QuizTagSwitcher.HOME_PAGE.equals(page));
        }
    }

    public static class QUIZ_NOT_DONE
    implements TagSwitcher {
        public Observable<Boolean> apply(Context context, Tag tag) {
            Property loggedUser = tag.getLoggedUserProperty(context);
            Generic quiz = context.getGeneric();
            if (loggedUser == null || !context.getRootContext().find(Quiz.class).getClass().isAssignableFrom(quiz.getClass())) {
                return null;
            }
            Generic scoreUser = (Generic)quiz.getLink((DefaultGeneric)context.getRootContext().find(ScoreUserQuiz.class), (DefaultGeneric[])new Generic[]{(Generic)loggedUser.getValue()});
            return RxJavaHelpers.optionalValuesOf((ObservableValue)loggedUser).map(optUser -> scoreUser == null);
        }
    }
}

