/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.quiz.utils;

import io.reactivex.Observable;
import java.util.Comparator;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.common.Generic;
import org.genericsystem.defaults.DefaultGeneric;
import org.genericsystem.defaults.tools.RxJavaHelpers;
import org.genericsystem.quiz.model.Answer;
import org.genericsystem.quiz.model.Description;
import org.genericsystem.quiz.model.Question;
import org.genericsystem.quiz.model.ScoreUserQuiz;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.Tag;
import org.genericsystem.reactor.context.ForEachExtractor;
import org.genericsystem.reactor.context.ForEachExtractorFromContext;
import org.genericsystem.reactor.context.GenericSelector;
import org.genericsystem.reactor.context.TagSwitcher;

public class QuizExtractors {

    public static class SCORES_FILTERED
    implements ForEachExtractorFromContext {
        public Observable<Snapshot<Generic>> apply(Context context, Tag tag) {
            Comparator byScoreUser = (score1, score2) -> {
                if (!score1.getClass().isAssignableFrom(score1.getRoot().find(ScoreUserQuiz.class).getClass()) || !score2.getClass().isAssignableFrom(score2.getRoot().find(ScoreUserQuiz.class).getClass())) {
                    return 0;
                }
                return Integer.compare((Integer)score2.getValue(), (Integer)score1.getValue());
            };
            Comparator byQuiz = (score1, score2) -> {
                if (!score1.getClass().isAssignableFrom(score1.getRoot().find(ScoreUserQuiz.class).getClass()) || !score2.getClass().isAssignableFrom(score2.getRoot().find(ScoreUserQuiz.class).getClass())) {
                    return 0;
                }
                return ((Generic)score1.getComponent(1)).compareTo(score2.getComponent(1));
            };
            return Observable.just((Object)context.getGeneric().getSubInstances().sort(byQuiz.thenComparing(byScoreUser)));
        }
    }

    public static class FILTER_USER
    implements TagSwitcher {
        public Observable<Boolean> apply(Context context, Tag tag) {
            if (tag.getContextProperty("selectedUser", context) == null) {
                tag.getRootTag().createNewContextProperty("selectedUser", (Context)context.getRootContext());
            }
            Property selectedUser = tag.getContextProperty("selectedUser", context);
            return RxJavaHelpers.optionalValuesOf((ObservableValue)selectedUser).map(optUser -> !optUser.isPresent() || ((String)optUser.get()).trim().isEmpty() || ((String)((Object)((Generic)context.getGeneric().getComponent(0)).getValue())).trim().toLowerCase().contains(((String)optUser.get()).trim().toLowerCase()));
        }
    }

    public static class FILTER_QUIZ
    implements TagSwitcher {
        public Observable<Boolean> apply(Context context, Tag tag) {
            if (tag.getContextProperty("selectedQuiz", context) == null) {
                tag.getRootTag().createNewContextProperty("selectedQuiz", (Context)context.getRootContext());
            }
            Property selectedQuiz = tag.getContextProperty("selectedQuiz", context);
            return RxJavaHelpers.optionalValuesOf((ObservableValue)selectedQuiz).map(optQuiz -> !optQuiz.isPresent() || ((Generic)context.getGeneric().getComponent(1)).equals(optQuiz.get()));
        }
    }

    public static class QUIZ_EXTRACTOR
    implements GenericSelector {
        public Generic apply(Generic[] generics) {
            return (Generic)generics[0].getComponent(1);
        }
    }

    public static class USER_EXTRACTOR
    implements GenericSelector {
        public Generic apply(Generic[] generics) {
            return (Generic)generics[0].getComponent(0);
        }
    }

    public static class DESCRIPTION_EXTRACTOR
    implements ForEachExtractor {
        public Observable<Snapshot<Generic>> apply(Generic[] generics) {
            return Observable.just((Object)generics[0].getHolders((DefaultGeneric)generics[0].getRoot().find(Description.class)));
        }
    }

    public static class QUESTIONS_EXTRACTOR
    implements ForEachExtractor {
        public Observable<Snapshot<Generic>> apply(Generic[] generics) {
            return Observable.just((Object)generics[0].getHolders((DefaultGeneric)generics[0].getRoot().find(Question.class)));
        }
    }

    public static class ANSWERS_EXTRACTOR
    implements ForEachExtractor {
        public Observable<Snapshot<Generic>> apply(Generic[] generics) {
            return Observable.just((Object)generics[0].getHolders((DefaultGeneric)generics[0].getRoot().find(Answer.class)));
        }
    }
}

