/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.quiz.utils;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.common.Generic;
import org.genericsystem.defaults.DefaultGeneric;
import org.genericsystem.quiz.model.Answer;
import org.genericsystem.quiz.model.Question;
import org.genericsystem.quiz.model.ScoreUserQuiz;
import org.genericsystem.quiz.model.UserAnswer;
import org.genericsystem.reactor.Context;

public class ScoreUtils {
    private static int calculateResult(Context context, Generic quiz, Generic sUser, Generic loggedUser) {
        Snapshot questions = quiz.getHolders((DefaultGeneric)context.find(Question.class));
        List listQuestions = questions.stream().collect(Collectors.toList());
        int total = 0;
        for (Generic question : listQuestions) {
            List listAnswers = question.getHolders((DefaultGeneric)context.find(Answer.class)).stream().collect(Collectors.toList());
            int pointByQuestion = 0;
            for (Generic answer : listAnswers) {
                Generic goodAnswer = (Generic)answer.getLink((DefaultGeneric)context.find(UserAnswer.class), (DefaultGeneric[])new Generic[]{sUser});
                Generic userAnswer = (Generic)answer.getLink((DefaultGeneric)context.find(UserAnswer.class), (DefaultGeneric[])new Generic[]{loggedUser});
                pointByQuestion = goodAnswer.getValue().equals(userAnswer.getValue()) ? ++pointByQuestion : --pointByQuestion;
            }
            if (pointByQuestion != listAnswers.size()) continue;
            ++total;
        }
        return total;
    }

    public static int getResult(Context context, Generic quiz, Generic user) {
        return (Integer)((Generic)quiz.getLink((DefaultGeneric)context.find(ScoreUserQuiz.class), (DefaultGeneric[])new Generic[]{user})).getValue();
    }

    public static void setResult(Context context, Generic quiz, int result, Generic user) {
        quiz.setLink((DefaultGeneric)context.find(ScoreUserQuiz.class), (Serializable)Integer.valueOf(result), (DefaultGeneric)user, (DefaultGeneric[])new Generic[0]);
        context.flush();
    }

    public static void setResult(Context context, Generic quiz, Generic sUser, Generic loggedUser) {
        ScoreUtils.setResult(context, quiz, ScoreUtils.calculateResult(context, quiz, sUser, loggedUser), loggedUser);
    }

    public static Snapshot<Generic> getResults(Context context, Generic quiz) {
        return quiz.getHolders((DefaultGeneric)context.find(ScoreUserQuiz.class));
    }

    public static Double getAverageResult(Context context, Generic quiz) {
        Snapshot<Generic> results = ScoreUtils.getResults(context, quiz);
        return results.stream().mapToInt(result -> (Integer)result.getValue()).average().getAsDouble();
    }

    public static Double getPercent(Context context, Generic quiz, double result) {
        return ScoreUtils.getPercent(ScoreUtils.getQuestions(context, quiz).size(), result);
    }

    public static Double getPercent(double xmax, double result) {
        return xmax != 0.0 ? Double.valueOf(result / xmax * 100.0) : null;
    }

    public static Stream<Double> getPercents(Context context, Generic quiz) {
        return ScoreUtils.getResults(context, quiz).stream().map(result -> ScoreUtils.getPercent(ScoreUtils.getQuestions(context, quiz).size(), ((Integer)result.getValue()).intValue()));
    }

    public static Double getAveragePercent(Context context, Generic quiz) {
        return ScoreUtils.getAveragePercent(ScoreUtils.getAverageResult(context, quiz), quiz.getHolders((DefaultGeneric)context.find(Question.class)).size());
    }

    public static Double getAveragePercent(double averageResult, int nQuestion) {
        return averageResult / (double)nQuestion * 100.0;
    }

    public static double getScore(double userPercent, double averagePercent) {
        return userPercent - averagePercent;
    }

    public static double getScore(Context context, Generic quiz, Generic user) {
        return ScoreUtils.getScore(ScoreUtils.getPercent(context, quiz, ScoreUtils.getResult(context, quiz, user)), ScoreUtils.getAveragePercent(context, quiz));
    }

    public static Stream<Double> getScores(Context context, Generic quiz) {
        return ScoreUtils.getResults(context, quiz).stream().map(result -> ScoreUtils.getScore(ScoreUtils.getPercent(context, quiz, ((Integer)result.getValue()).intValue()), ScoreUtils.getAveragePercent(context, quiz))).sorted();
    }

    public static Double getAverageScore(Context context, Generic quiz) {
        return ScoreUtils.getAverageScore(ScoreUtils.getScores(context, quiz));
    }

    public static Double getAverageScore(Stream<Double> numberStream) {
        return numberStream.mapToDouble(score -> score).average().getAsDouble();
    }

    public static Double calculateSimpleGrade(Context context, Generic quiz, Generic user) {
        List scores = ScoreUtils.getScores(context, quiz).collect(Collectors.toList());
        Double scoreMin = (Double)scores.get(0);
        Double scoreMax = (Double)scores.get(scores.size() - 1);
        Double average = ScoreUtils.getAverageScore(ScoreUtils.getScores(context, quiz));
        Double y = ScoreUtils.getScore(context, quiz, user);
        Double b = average;
        Double a = null;
        a = Math.abs(scoreMax) >= Math.abs(scoreMin) ? ScoreUtils.getA(scoreMax, b, 10.0) : ScoreUtils.getA(scoreMin, b, -10.0);
        return (double)Math.round(ScoreUtils.calculateSimpleGrade(a, y, b) * 100.0) / 100.0;
    }

    public static Double calculateDualGrade(Context context, Generic quiz, Generic user) {
        List scores = ScoreUtils.getScores(context, quiz).collect(Collectors.toList());
        Double scoreMin = (Double)scores.get(0);
        Double scoreMax = (Double)scores.get(scores.size() - 1);
        Double average = ScoreUtils.getAverageScore(ScoreUtils.getScores(context, quiz));
        Double y = ScoreUtils.getScore(context, quiz, user);
        Double b = average;
        Double a = null;
        a = y >= b ? ScoreUtils.getA(scoreMax, b, 10.0) : ScoreUtils.getA(scoreMin, b, -10.0);
        return (double)Math.round(ScoreUtils.calculateSimpleGrade(a, y, b) * 100.0) / 100.0;
    }

    public static Double calculateSimpleGrade(Double a, Double y, Double b) {
        return (y - b) / a + 10.0;
    }

    public static Double getA(Double yMax, Double b, Double yRef) {
        return (yMax - b) / yRef;
    }

    public static double expectation(List<Double> percents) {
        double sum = 0.0;
        for (double p : percents) {
            sum += p;
        }
        return sum / (double)percents.size();
    }

    public static Double variance(List<Double> percents) {
        if (percents == null) {
            return null;
        }
        int size = percents.size();
        if (size <= 1) {
            return 0.0;
        }
        double expectation = ScoreUtils.expectation(percents);
        System.out.println("expectation -> " + expectation + "%");
        double sum = 0.0;
        for (double p : percents) {
            sum += Math.pow(p - expectation, 2.0);
            System.out.println("\tscore -> " + p + "%");
        }
        return sum / (double)size;
    }

    public static Double normalization() {
        return null;
    }

    private static Snapshot<Generic> getQuestions(Context context, Generic quiz) {
        return quiz.getHolders((DefaultGeneric)context.find(Question.class));
    }
}

