/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.quiz.app.pages.components;

import org.genericsystem.common.Generic;
import org.genericsystem.defaults.DefaultGeneric;
import org.genericsystem.quiz.model.ScoreUserQuiz;
import org.genericsystem.quiz.utils.QuizExtractors;
import org.genericsystem.quiz.utils.ScoreUtils;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.annotations.Attribute;
import org.genericsystem.reactor.annotations.BindText;
import org.genericsystem.reactor.annotations.Children;
import org.genericsystem.reactor.annotations.DirectSelect;
import org.genericsystem.reactor.annotations.ForEachContext;
import org.genericsystem.reactor.annotations.Select;
import org.genericsystem.reactor.annotations.SelectContext;
import org.genericsystem.reactor.annotations.SetText;
import org.genericsystem.reactor.annotations.Style;
import org.genericsystem.reactor.annotations.StyleClass;
import org.genericsystem.reactor.annotations.Switch;
import org.genericsystem.reactor.context.OptionalContextSelector;
import org.genericsystem.reactor.contextproperties.SelectionDefaults;
import org.genericsystem.reactor.gscomponents.FlexDiv;
import org.genericsystem.reactor.gscomponents.HtmlTag;

@Children(value={SummaryResults.class, AllResults.class})
@Style(name="align-items", value="center")
public class QuizResult
extends FlexDiv {

    public static class QuizDiv
    extends FlexDiv {
    }

    public static class Score02
    extends FlexDiv {
        public void init() {
            this.addPrefixBinding(context -> {
                Double grade01 = ScoreUtils.calculateDualGrade(context, (Generic)context.getGeneric().getComponent(1), (Generic)context.getGeneric().getComponent(0));
                this.setText((Context)context, grade01 + " / 20 ");
            });
        }
    }

    public static class Score01
    extends FlexDiv {
        public void init() {
            this.addPrefixBinding(context -> {
                Double grade = ScoreUtils.calculateSimpleGrade(context, (Generic)context.getGeneric().getComponent(1), (Generic)context.getGeneric().getComponent(0));
                this.setText((Context)context, grade + " / 20");
            });
        }
    }

    public static class UserDiv
    extends FlexDiv {
    }

    @ForEachContext(value=QuizExtractors.SCORES_FILTERED.class)
    @Switch(value={QuizExtractors.FILTER_QUIZ.class, QuizExtractors.FILTER_USER.class})
    @Children(value={UserDiv.class, FlexDiv.class, Score01.class, Score02.class, QuizDiv.class})
    @Select.Selects(value={@Select(path={UserDiv.class}, value=QuizExtractors.USER_EXTRACTOR.class), @Select(path={QuizDiv.class}, value=QuizExtractors.QUIZ_EXTRACTOR.class)})
    @BindText.BindTexts(value={@BindText(path={UserDiv.class}), @BindText(path={HtmlTag.HtmlDiv.class}, pos={1}), @BindText(path={QuizDiv.class})})
    public static class ScoreDiv
    extends FlexDiv.FlexRow {
        public void init() {
            this.addPrefixBinding(context -> {
                if (((Generic)context.getGeneric().getComponent(0)).equals(this.getLoggedUserProperty((Context)context).getValue())) {
                    this.addStyle((Context)context, "background-color", "#FFE9C5");
                    this.addStyle((Context)context, "font-weight", "bold");
                }
                this.getLoggedUserProperty((Context)context).addListener((observable, oldValue, newValue) -> {
                    if (!context.isDestroyed()) {
                        if (newValue == null) {
                            this.addStyle((Context)context, "background-color", "inherit");
                            this.addStyle((Context)context, "font-weight", "normal");
                        }
                        if (newValue != null && newValue.equals(context.getGeneric().getComponent(0))) {
                            this.addStyle((Context)context, "background-color", "#FFE9C5");
                            this.addStyle((Context)context, "font-weight", "bold");
                        }
                    }
                });
            });
        }
    }

    @Children(value={FlexDiv.class, FlexDiv.class, FlexDiv.class, FlexDiv.class, FlexDiv.class})
    @SetText.SetTexts(value={@SetText(path={FlexDiv.class}, pos={0}, value={"Pseudo"}), @SetText(path={FlexDiv.class}, pos={1}, value={"R\u00e9ponses correctes"}), @SetText(path={FlexDiv.class}, pos={2}, value={"Score 1"}), @SetText(path={FlexDiv.class}, pos={3}, value={"Score 2"}), @SetText(path={FlexDiv.class}, pos={4}, value={"Quiz"})})
    public static class TitleResult
    extends FlexDiv.FlexRow {
    }

    @Attribute(name="placeholder", value="Entrer un nom d'utilisateur")
    @StyleClass(value={"inputTextQ", "inputTextSearchQ"})
    public static class Search
    extends HtmlTag.HtmlInputText {
        public void init() {
            this.addPrefixBinding(context -> this.getDomNodeAttributes((Context)context).addListener(change -> {
                if ("value".equals(change.getKey()) && change.wasAdded()) {
                    this.getContextProperty("selectedUser", (Context)context).setValue(change.getValueAdded());
                }
            }));
        }
    }

    @DirectSelect(value={ScoreUserQuiz.class})
    @Children.ChildrenMult(value={@Children(value={HtmlTag.HtmlDiv.class, TitleResult.class, ScoreDiv.class}), @Children(path={HtmlTag.HtmlDiv.class}, pos={0}, value={Search.class})})
    @Style.Styles(value={@Style(name="width", value="90%"), @Style(path={FlexDiv.class}, name="flex", value="1"), @Style(path={FlexDiv.class, FlexDiv.class}, name="flex", value="1"), @Style(path={HtmlTag.HtmlDiv.class}, pos={0}, name="text-align", value="right"), @Style(path={HtmlTag.HtmlDiv.class}, pos={0}, name="margin-bottom", value="15px"), @Style(path={TitleResult.class}, name="min-height", value="40px"), @Style(path={ScoreDiv.class, UserDiv.class}, name="border-left", value="0.5px solid grey"), @Style(path={ScoreDiv.class, QuizDiv.class}, name="border-right", value="0.5px solid grey")})
    @StyleClass.StyleClasses(value={@StyleClass(path={TitleResult.class}, value={"titleTableDivQ"}), @StyleClass(path={TitleResult.class, FlexDiv.class}, value={"titleTableCellQ"}), @StyleClass(path={ScoreDiv.class, FlexDiv.class}, value={"scoreTableCellQ"})})
    @SetText(path={HtmlTag.HtmlDiv.class, HtmlTag.HtmlButton.class}, value={"Rechercher"})
    public static class AllResults
    extends FlexDiv {
    }

    public static class MyResultP
    extends HtmlTag.HtmlP {
        public void init() {
            this.addPrefixBinding(context -> {
                Generic quiz = context.getGeneric();
                Generic user = (Generic)this.getLoggedUserProperty((Context)context).getValue();
                Generic scoreUserQuiz = (Generic)user.getLink((DefaultGeneric)context.find(ScoreUserQuiz.class), (DefaultGeneric[])new Generic[]{quiz});
                Double grade02 = ScoreUtils.calculateDualGrade(context, quiz, user);
                String goodAnswer = (Integer)scoreUserQuiz.getValue() > 1 ? " bonnes r\u00e9ponses" : " bonne r\u00e9ponse";
                String point = grade02 > 1.0 ? " points" : " point";
                this.setText((Context)context, "Vous venez de terminer le quiz.\nVotre Score est de " + grade02 + point + "\nVous avez eu " + scoreUserQuiz + goodAnswer);
            });
        }
    }

    public static class TitleResultH1
    extends HtmlTag.HtmlH1 {
        public void init() {
            this.addPrefixBinding(context -> this.setText((Context)context, "R\u00e9capitulatif des r\u00e9sultats pour le quiz : " + context.getGeneric()));
        }
    }

    @Children(value={TitleResultH1.class, MyResultP.class})
    @Style(name="width", value="90%")
    @StyleClass(value={"myResultDiv"})
    public static class MySumResult
    extends FlexDiv {
    }

    @Children(value={MySumResult.class})
    @SelectContext(value=OptionalContextSelector.SELECTION_SELECTOR.class)
    @Style.Styles(value={@Style(name="width", value="100%"), @Style(name="align-items", value="center")})
    public static class SummaryResults
    extends FlexDiv
    implements SelectionDefaults {
    }
}

