/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.quiz.utils;

import java.io.Serializable;
import javafx.beans.property.Property;
import org.genericsystem.common.Generic;
import org.genericsystem.defaults.DefaultGeneric;
import org.genericsystem.quiz.model.Quiz;
import org.genericsystem.quiz.utils.ScoreUtils;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.Tag;
import org.genericsystem.reactor.context.ContextAction;
import org.genericsystem.reactor.gscomponents.HtmlTag;
import org.genericsystem.security.model.User;

public class QuizContextAction {
    public static final String SUPER_USER = "superUser";
    public static final String SELECTED_QUIZ = "selectedQuiz";
    public static final String SELECTED_USER = "selectedUser";

    public static class CALL_QUESTION_PAGE
    implements ContextAction {
        public void accept(Context context, Tag tag) {
            tag.setInheritedContextPropertyValue("Page", context, (Object)"QuestionPage");
        }
    }

    public static class CALL_RESULT_PAGE
    implements ContextAction {
        public void accept(Context context, Tag tag) {
            tag.setInheritedContextPropertyValue("Page", context, (Object)"ResultPage");
        }
    }

    public static class CALL_HOME_PAGE
    implements ContextAction {
        public void accept(Context context, Tag tag) {
            tag.setInheritedContextPropertyValue("Page", context, (Object)"HomePage");
        }
    }

    public static class CLEAR_PAGES
    implements ContextAction {
        public void accept(Context context, Tag tag) {
            if (tag.getContextProperty("Page", context) != null) {
                tag.getContextProperty("Page", context).setValue(null);
            }
        }
    }

    public static class SAVE_QUIZ_RESULT
    implements ContextAction {
        public void accept(Context context, Tag tag) {
            Generic quiz = ((Context)tag.getSelectionProperty(context).getValue()).getGeneric();
            Generic sUser = (Generic)context.find(User.class).getInstance((Serializable)((Object)QuizContextAction.SUPER_USER), (DefaultGeneric[])new Generic[0]);
            Generic loggedUser = (Generic)tag.getLoggedUserProperty(context).getValue();
            ScoreUtils.setResult(context, quiz, sUser, loggedUser);
            ScoreUtils.getResult(context, quiz, loggedUser);
        }
    }

    public static class SELECT_LOGGEDUSER
    implements ContextAction {
        public void accept(Context context, Tag tag) {
            Property loggedUser = tag.getLoggedUserProperty(context);
            if (loggedUser == null) {
                return;
            }
            tag.getRootTag().setContextPropertyValue(QuizContextAction.SELECTED_USER, (Context)context.getRootContext(), (Object)(loggedUser.getValue() + ""));
        }
    }

    public static class SELECT_QUIZ
    implements ContextAction {
        public void accept(Context context, Tag tag) {
            Generic quiz = context.getGeneric();
            if (!quiz.getRoot().find(Quiz.class).equals(quiz.getMeta())) {
                return;
            }
            tag.getRootTag().setContextPropertyValue(QuizContextAction.SELECTED_QUIZ, (Context)context.getRootContext(), (Object)quiz);
        }
    }

    public static class CLEAR_QUIZCONTEXT_PROPERTIES
    implements ContextAction {
        public void accept(Context context, Tag tag) {
            new CLEAR_USER().accept(context, tag);
            new CLEAR_QUIZ().accept(context, tag);
        }
    }

    public static class CLEAR_USER
    implements ContextAction {
        public void accept(Context context, Tag tag) {
            Property selectedUser = tag.getContextProperty(QuizContextAction.SELECTED_USER, context);
            if (selectedUser == null) {
                tag.getRootTag().createNewContextProperty(QuizContextAction.SELECTED_USER);
                return;
            }
            if (selectedUser.getValue() == null) {
                return;
            }
            selectedUser.setValue(null);
        }
    }

    public static class CLEAR_QUIZ
    implements ContextAction {
        public void accept(Context context, Tag tag) {
            Property selectedQuiz = tag.getContextProperty(QuizContextAction.SELECTED_QUIZ, context);
            if (selectedQuiz == null) {
                tag.getRootTag().createNewContextProperty(QuizContextAction.SELECTED_QUIZ);
                return;
            }
            if (selectedQuiz.getValue() == null) {
                return;
            }
            selectedQuiz.setValue(null);
        }
    }

    public static class ADD_LISTENED_PROPERTY
    implements ContextAction {
        public static final String INPUTTEXT_VALUE = "Input Text Value";

        public void accept(Context context, Tag tag) {
            if (!tag.getClass().isAssignableFrom(HtmlTag.HtmlInputText.class)) {
                return;
            }
            Property inputProperty = tag.getContextProperty(INPUTTEXT_VALUE, context);
            if (inputProperty == null) {
                tag.getParent().createNewInitializedProperty(INPUTTEXT_VALUE, value -> null);
            }
            tag.getContextProperty(INPUTTEXT_VALUE, context).setValue(tag.getDomNodeAttributes(context).get((Object)"value"));
        }
    }
}

