/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.mutability;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.List;
import javassist.util.proxy.MethodHandler;
import org.genericsystem.defaults.DefaultRoot;
import org.genericsystem.mutability.Cache;
import org.genericsystem.mutability.Generic;

public class Engine
implements Generic,
DefaultRoot<Generic>,
MethodHandler {
    protected final InheritableThreadLocal<Cache> cacheLocal = new InheritableThreadLocal();
    private final org.genericsystem.cache.Engine cacheEngine;

    public Engine(Class<?> ... userClasses) {
        this((Serializable)((Object)"Engine"), userClasses);
    }

    public Engine(Serializable engineValue, Class<?> ... userClasses) {
        this(engineValue, (String)null, userClasses);
    }

    public Engine(Serializable engineValue, String persistentDirectoryPath, Class<?> ... userClasses) {
        this.cacheEngine = new org.genericsystem.cache.Engine(engineValue, persistentDirectoryPath, (Class[])userClasses);
        this.newCache().start();
    }

    @Override
    public boolean isSystem() {
        return this.cacheEngine.isSystem();
    }

    public Object invoke(Object self, Method m, Method proceed, Object[] args) throws Throwable {
        if (m.getName().equals("getRoot")) {
            return this;
        }
        return ((Generic)self).defaultToString();
    }

    @Override
    public Engine getRoot() {
        return this;
    }

    public <Custom extends Generic> Custom find(Class<?> clazz) {
        return (Custom)this.getCurrentCache().wrap(clazz, this.cacheEngine.find(clazz));
    }

    public <Custom extends Generic> Custom bind(Class<?> clazz) {
        return (Custom)this.getCurrentCache().wrap(clazz, this.cacheEngine.bind(clazz));
    }

    public Class<?> findAnnotedClass(Generic vertex) {
        return this.cacheEngine.findAnnotedClass(this.getCurrentCache().unwrap(vertex));
    }

    public Cache newCache() {
        return new Cache(this, this.cacheEngine);
    }

    Cache start(Cache cache) {
        if (!this.equals(cache.getRoot())) {
            throw new IllegalStateException();
        }
        this.cacheLocal.set(cache);
        return cache;
    }

    void stop(Cache cache) {
        assert (this.cacheLocal.get() == cache);
        this.cacheLocal.set(null);
    }

    @Override
    public Cache getCurrentCache() {
        Cache currentCache = (Cache)this.cacheLocal.get();
        if (currentCache == null) {
            throw new IllegalStateException("Unable to find the current cache. Did you miss to call start() method on it ?");
        }
        return currentCache;
    }

    public org.genericsystem.cache.Engine getConcurrencyEngine() {
        return this.cacheEngine;
    }

    public void close() {
        this.cacheEngine.close();
    }

    public long getTs(Generic generic) {
        return this.getCurrentCache().unwrap(generic).getTs();
    }

    public Generic getMeta(Generic generic) {
        return this.getCurrentCache().wrap((org.genericsystem.kernel.Generic)this.getCurrentCache().unwrap(generic).getMeta());
    }

    public List<Generic> getSupers(Generic generic) {
        return this.getCurrentCache().wrap(this.getCurrentCache().unwrap(generic).getSupers());
    }

    public Serializable getValue(Generic generic) {
        return this.getCurrentCache().unwrap(generic).getValue();
    }

    public List<Generic> getComponents(Generic generic) {
        return this.getCurrentCache().wrap(this.getCurrentCache().unwrap(generic).getComponents());
    }

    public String toString() {
        return this.defaultToString();
    }
}

