/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.mutability;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.api.core.annotations.InstanceClass;
import org.genericsystem.api.core.exceptions.AliveConstraintViolationException;
import org.genericsystem.api.core.exceptions.RollbackException;
import org.genericsystem.cache.Cache;
import org.genericsystem.defaults.DefaultContext;
import org.genericsystem.defaults.DefaultVertex;
import org.genericsystem.mutability.Engine;
import org.genericsystem.mutability.Generic;

public class Cache
implements DefaultContext<Generic>,
Cache.ContextEventListener<org.genericsystem.kernel.Generic> {
    private final Engine engine;
    org.genericsystem.cache.Cache cache;
    private final Map<Generic, org.genericsystem.kernel.Generic> mutabilityMap = new IdentityHashMap<Generic, org.genericsystem.kernel.Generic>();
    private final Map<org.genericsystem.kernel.Generic, Set<Generic>> reverseMultiMap = new IdentityHashMap<org.genericsystem.kernel.Generic, Set<Generic>>();
    private final Deque<Map<Generic, org.genericsystem.kernel.Generic>> revertMutations = new ArrayDeque<Map<Generic, org.genericsystem.kernel.Generic>>();
    private static final ProxyFactory PROXY_FACTORY = new ProxyFactory();
    private static final MethodFilter METHOD_FILTER = method -> method.getName().equals("getRoot");

    public Cache(Engine engine, org.genericsystem.cache.Engine cacheEngine) {
        this.engine = engine;
        this.put(engine, (org.genericsystem.kernel.Generic)cacheEngine);
        this.cache = cacheEngine.newCache((Cache.ContextEventListener)this);
        this.revertMutations.push(new IdentityHashMap());
    }

    public Engine getRoot() {
        return this.engine;
    }

    public Cache start() {
        this.cache.start();
        return this.engine.start(this);
    }

    public void stop() {
        this.cache.stop();
        this.engine.stop(this);
    }

    protected org.genericsystem.kernel.Generic unwrap(Generic mutable) {
        if (mutable == null) {
            return null;
        }
        org.genericsystem.kernel.Generic result = this.mutabilityMap.get(mutable);
        if (result == null) {
            this.cache.discardWithException((Throwable)new AliveConstraintViolationException("Your mutable is not still available"));
        }
        return result;
    }

    protected Generic wrap(Class<?> clazz, org.genericsystem.kernel.Generic generic) {
        Generic result;
        if (generic == null) {
            return null;
        }
        Set<Generic> resultSet = this.reverseMultiMap.get(generic);
        if (resultSet != null) {
            return resultSet.iterator().next();
        }
        InstanceClass instanceClassAnnotation = null;
        Class findAnnotedClass = this.cache.getRoot().findAnnotedClass(generic.getMeta());
        if (findAnnotedClass != null) {
            instanceClassAnnotation = findAnnotedClass.getAnnotation(InstanceClass.class);
        }
        if (clazz != null) {
            if (instanceClassAnnotation != null && !instanceClassAnnotation.value().isAssignableFrom(clazz)) {
                this.cache.discardWithException((Throwable)new InstantiationException(clazz + " must extends " + instanceClassAnnotation.value()));
            }
            result = (Generic)this.newInstance(clazz);
        } else {
            result = (Generic)this.newInstance(instanceClassAnnotation != null ? instanceClassAnnotation.value() : Object.class);
        }
        this.put(result, generic);
        return result;
    }

    protected Generic wrap(org.genericsystem.kernel.Generic generic) {
        return generic != null ? this.wrap(generic.getRoot().findAnnotedClass(generic), generic) : null;
    }

    private void put(Generic mutable, org.genericsystem.kernel.Generic generic) {
        this.mutabilityMap.put(mutable, generic);
        Set set = Collections.newSetFromMap(new IdentityHashMap());
        set.add(mutable);
        this.reverseMultiMap.put(generic, set);
    }

    public void triggersMutationEvent(org.genericsystem.kernel.Generic oldDependency, org.genericsystem.kernel.Generic newDependency) {
        System.out.println(oldDependency.info() + " " + newDependency.info());
        Set<Generic> resultSet = this.reverseMultiMap.remove(oldDependency);
        if (resultSet == null) {
            return;
        }
        for (Generic mutable : resultSet) {
            this.revertMutations.peek().computeIfAbsent(mutable, k -> oldDependency);
            this.mutabilityMap.put(mutable, newDependency);
        }
        Set<Generic> newDependencySet = this.reverseMultiMap.get(newDependency);
        if (newDependencySet != null) {
            resultSet.addAll(newDependencySet);
        }
        this.reverseMultiMap.put(newDependency, resultSet);
    }

    public void triggersRefreshEvent() {
        Iterator<Map.Entry<org.genericsystem.kernel.Generic, Set<Generic>>> iterator = this.reverseMultiMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<org.genericsystem.kernel.Generic, Set<Generic>> entry = iterator.next();
            if (this.cache.isAlive((DefaultVertex)entry.getKey())) continue;
            for (Generic mutable : entry.getValue()) {
                this.mutabilityMap.remove(mutable);
            }
            iterator.remove();
        }
    }

    public void triggersClearEvent() {
        this.revertMutations.peek().forEach((mutable, generic) -> {
            org.genericsystem.kernel.Generic newDependency = this.mutabilityMap.get(mutable);
            this.mutabilityMap.put((Generic)mutable, (org.genericsystem.kernel.Generic)generic);
            if (newDependency != null) {
                Set<Generic> set = this.reverseMultiMap.get(newDependency);
                set.remove(mutable);
                if (set.isEmpty()) {
                    this.reverseMultiMap.remove(newDependency);
                }
                set = this.reverseMultiMap.getOrDefault(generic, Collections.newSetFromMap(new IdentityHashMap()));
                set.add((Generic)mutable);
                this.reverseMultiMap.put((org.genericsystem.kernel.Generic)generic, set);
            }
        });
        this.revertMutations.pop();
        this.revertMutations.push(new IdentityHashMap());
    }

    protected List<Generic> wrap(List<org.genericsystem.kernel.Generic> listT) {
        return listT.stream().map(this::wrap).collect(Collectors.toList());
    }

    protected List<org.genericsystem.kernel.Generic> unwrap(List<Generic> listM) {
        return listM.stream().map(this::unwrap).collect(Collectors.toList());
    }

    protected Generic[] wrap(org.genericsystem.kernel.Generic ... array) {
        return Arrays.asList(array).stream().map(this::wrap).collect(Collectors.toList()).toArray(new Generic[array.length]);
    }

    protected org.genericsystem.kernel.Generic[] unwrap(Generic ... listM) {
        return (org.genericsystem.kernel.Generic[])this.engine.getConcurrencyEngine().coerceToTArray(Arrays.asList(listM).stream().map(this::unwrap).collect(Collectors.toList()).toArray());
    }

    public void triggersFlushEvent() {
        this.revertMutations.push(new IdentityHashMap());
    }

    public boolean isAlive(Generic mutable) {
        org.genericsystem.kernel.Generic generic = this.mutabilityMap.get(mutable);
        return generic != null && this.cache.isAlive((DefaultVertex)generic);
    }

    public void shiftTs() {
        this.cache.shiftTs();
    }

    public void tryFlush() {
        this.cache.tryFlush();
    }

    public void flush() {
        this.cache.flush();
    }

    public long getTs() {
        return this.cache.getTs();
    }

    public void clear() {
        this.cache.clear();
    }

    <T> T newInstance(Class<?> clazz) {
        PROXY_FACTORY.setSuperclass(clazz);
        if (!Generic.class.isAssignableFrom(clazz)) {
            PROXY_FACTORY.setInterfaces(new Class[]{Generic.class});
        }
        T instance = null;
        try {
            instance = PROXY_FACTORY.createClass(METHOD_FILTER).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.cache.discardWithException((Throwable)e);
        }
        ((ProxyObject)instance).setHandler((MethodHandler)this.engine);
        return instance;
    }

    public void mount() {
        this.cache.mount();
        this.revertMutations.push(new IdentityHashMap());
    }

    public void unmount() {
        this.cache.unmount();
        this.revertMutations.pop();
    }

    public int getCacheLevel() {
        return this.cache.getCacheLevel();
    }

    public Snapshot<Generic> getDependencies(Generic generic) {
        return () -> this.cache.getDependencies(this.unwrap(generic)).get().map(this::wrap);
    }

    public void discardWithException(Throwable exception) throws RollbackException {
        this.cache.discardWithException(exception);
    }

    public Generic[] newTArray(int dim) {
        return (Generic[])Array.newInstance(Generic.class, dim);
    }

    public Generic addInstance(Generic meta, List<Generic> overrides, Serializable value, List<Generic> components) {
        return this.wrap(this.cache.addInstance(this.unwrap(meta), this.unwrap(overrides), value, this.unwrap(components)));
    }

    public Generic update(Generic update, List<Generic> overrides, Serializable newValue, List<Generic> newComponents) {
        return this.wrap(this.cache.update(this.unwrap(update), this.unwrap(overrides), newValue, this.unwrap(newComponents)));
    }

    public Generic setInstance(Generic meta, List<Generic> overrides, Serializable value, List<Generic> components) {
        return this.wrap(this.cache.setInstance(this.unwrap(meta), this.unwrap(overrides), value, this.unwrap(components)));
    }

    public void forceRemove(Generic generic) {
        this.cache.forceRemove(this.unwrap(generic));
    }

    public void remove(Generic generic) {
        this.cache.remove(this.unwrap(generic));
    }

    public void conserveRemove(Generic generic) {
        this.cache.conserveRemove(this.unwrap(generic));
    }
}

