/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.mutability;

import java.io.Serializable;
import java.lang.reflect.Method;
import javassist.util.proxy.MethodHandler;
import org.genericsystem.api.defaults.DefaultRoot;
import org.genericsystem.kernel.Config;
import org.genericsystem.mutability.Cache;
import org.genericsystem.mutability.Generic;

public class Engine
implements Generic,
DefaultRoot<Generic>,
MethodHandler {
    protected final ThreadLocal<Cache> cacheLocal = new ThreadLocal();
    private final org.genericsystem.cache.Engine cacheEngine;

    public Engine() {
        this.cacheEngine = new org.genericsystem.cache.Engine(new Class[0]);
        this.newCache().start();
    }

    public Engine(Class<?> ... userClasses) {
        this((Serializable)((Object)"Engine"), userClasses);
    }

    public Engine(Serializable engineValue, Class<?> ... userClasses) {
        this(engineValue, (String)null, userClasses);
    }

    public Engine(Serializable engineValue, String persistentDirectoryPath, Class<?> ... userClasses) {
        this.cacheEngine = new org.genericsystem.cache.Engine(engineValue, persistentDirectoryPath, (Class[])userClasses);
        this.newCache().start();
    }

    @Override
    public boolean isSystem() {
        return this.cacheEngine.isSystem();
    }

    public Object invoke(Object self, Method m, Method proceed, Object[] args) throws Throwable {
        return this;
    }

    @Override
    public Engine getRoot() {
        return this;
    }

    public <Custom extends Generic> Custom find(Class<?> clazz) {
        return (Custom)this.getCurrentCache().wrap(clazz, this.cacheEngine.find(clazz));
    }

    public Cache newCache() {
        return new Cache(this, this.cacheEngine);
    }

    Cache start(Cache cache) {
        if (!this.equals(cache.getRoot())) {
            throw new IllegalStateException();
        }
        this.cacheLocal.set(cache);
        return cache;
    }

    void stop(Cache cache) {
        assert (this.cacheLocal.get() == cache);
        this.cacheLocal.set(null);
    }

    @Override
    public Cache getCurrentCache() {
        Cache currentCache = this.cacheLocal.get();
        if (currentCache == null) {
            throw new IllegalStateException("Unable to find the current cache. Did you miss to call start() method on it ?");
        }
        return currentCache;
    }

    public Generic getMetaAttribute() {
        return this.getCurrentCache().wrap(this.cacheEngine.getMetaAttribute());
    }

    public Generic getMetaRelation() {
        return this.getCurrentCache().wrap(this.cacheEngine.getMetaRelation());
    }

    public org.genericsystem.cache.Engine getConcurrencyEngine() {
        return this.cacheEngine;
    }

    public void close() {
        this.cacheEngine.close();
    }

    public Generic getMap() {
        return this.find(Config.SystemMap.class);
    }
}

