/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.remote;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.genericsystem.api.core.exceptions.ConcurrencyControlException;
import org.genericsystem.api.core.exceptions.OptimisticLockConstraintViolationException;
import org.genericsystem.common.GSBuffer;
import org.genericsystem.common.Protocol;
import org.genericsystem.common.Statics;
import org.genericsystem.common.Vertex;
import org.genericsystem.remote.WebSocketClient;

public class FrontEnd
implements Protocol {
    protected WebSocketClient webSocketClient;
    private final Map<Integer, Consumer<GSBuffer>> ops = new HashMap<Integer, Consumer<GSBuffer>>();
    private final AtomicInteger atomicKey = new AtomicInteger(0);
    private final Handler<Buffer> handler = buf -> {
        GSBuffer gsBuffer = new GSBuffer(buf);
        int optype = gsBuffer.getInt();
        this.ops.remove(optype).accept(gsBuffer);
    };

    public FrontEnd(String host, int port, String path) {
        this.webSocketClient = new WebSocketClient(this, host, port, path);
    }

    protected <T> void send(Buffer buffer) {
        this.webSocketClient.send(buffer);
    }

    public void close() {
        this.webSocketClient.close();
    }

    protected Handler<Buffer> getHandler() {
        return this.handler;
    }

    private int indexCallback(Consumer<GSBuffer> promise) {
        int key = this.atomicKey.incrementAndGet();
        this.ops.put(key, promise);
        return key;
    }

    protected <T> CompletableFuture<T> promise(int method, Function<GSBuffer, T> receiveReturn, Function<Buffer, Buffer> sendParams) {
        CompletableFuture promise = new CompletableFuture();
        int key = this.indexCallback(buff -> promise.complete(receiveReturn.apply((GSBuffer)buff)));
        this.send(sendParams.apply(Buffer.buffer().appendInt(method).appendInt(key)));
        return promise.thenApplyAsync(p -> p);
    }

    protected <T, R> R extractRuntimeException(UnsafeSupplier<R> unsafe) {
        try {
            return unsafe.supply();
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new IllegalStateException(e);
        }
    }

    protected <R> R extractRuntimeExceptionPromise(Supplier<Object> unsafe) {
        Object result = unsafe.get();
        if (result instanceof RuntimeException) {
            throw (RuntimeException)result;
        }
        return (R)result;
    }

    public Vertex getVertex(long id) {
        return this.extractRuntimeException(() -> this.getVertexPromise(id).get());
    }

    public CompletableFuture<Vertex> getVertexPromise(long id) {
        return (CompletableFuture)this.extractRuntimeExceptionPromise(() -> this.promise(2, buff -> buff.getGSVertexThrowException(), buffer -> buffer.appendLong(id)));
    }

    public long pickNewTs() {
        return this.extractRuntimeException(() -> this.getPickNewTsPromise().get(1000L, Statics.SERVER_TIMEOUT_UNIT));
    }

    public CompletableFuture<Long> getPickNewTsPromise() {
        return (CompletableFuture)this.extractRuntimeExceptionPromise(() -> this.promise(0, buff -> buff.getLongThrowException(), buffer -> buffer));
    }

    public Vertex[] getDependencies(long ts, long id) {
        return this.extractRuntimeException(() -> this.getDependenciesPromise(ts, id).get(1000L, Statics.SERVER_TIMEOUT_UNIT));
    }

    public CompletableFuture<Vertex[]> getDependenciesPromise(long ts, long id) {
        return (CompletableFuture)this.extractRuntimeExceptionPromise(() -> this.promise(1, buff -> buff.getGSVertexArrayThrowException(), buffer -> buffer.appendLong(ts).appendLong(id)));
    }

    public void apply(long ts, long[] removes, Vertex[] adds) throws ConcurrencyControlException, OptimisticLockConstraintViolationException {
        if (!Arrays.stream(adds).allMatch(v -> v.getBirthTs() == Long.MAX_VALUE)) {
            throw new IllegalStateException("");
        }
        Object res = this.extractRuntimeException(() -> this.applyPromise(ts, removes, adds).get(1000L, Statics.SERVER_TIMEOUT_UNIT));
        if (res instanceof OptimisticLockConstraintViolationException) {
            throw (OptimisticLockConstraintViolationException)res;
        }
        if (res instanceof ConcurrencyControlException) {
            throw (ConcurrencyControlException)res;
        }
        if (res instanceof Throwable) {
            throw new IllegalStateException((Throwable)res);
        }
    }

    public CompletableFuture<Object> applyPromise(long ts, long[] removes, Vertex[] adds) {
        return this.promise(3, buff -> buff.getLongThrowException(), buffer -> {
            GSBuffer gsBuffer = new GSBuffer(buffer);
            gsBuffer.appendLong(ts);
            gsBuffer.appendGSLongArray(removes);
            gsBuffer.appendGSVertexArray(adds);
            return gsBuffer;
        });
    }

    @FunctionalInterface
    public static interface UnsafeSupplier<R> {
        public R supply() throws InterruptedException, ExecutionException, TimeoutException;
    }
}

