/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import io.reactivex.Observable;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.genericsystem.api.core.IndexFilter;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.api.core.exceptions.ConcurrencyControlException;
import org.genericsystem.api.core.exceptions.OptimisticLockConstraintViolationException;
import org.genericsystem.api.tools.Memoizer;
import org.genericsystem.common.CheckedContext;
import org.genericsystem.common.Generic;
import org.genericsystem.common.IDependencies;
import org.genericsystem.common.IDifferential;
import org.genericsystem.common.Root;
import org.genericsystem.kernel.AbstractServer;
import org.genericsystem.kernel.LifeManager;

public class Transaction
extends CheckedContext
implements IDifferential<Generic> {
    private final long ts;
    private final Function<Generic, Observable<Generic>> addsM = Memoizer.memoize(generic -> this.getDependencies((Generic)generic).getAdds());
    private final Function<Generic, Observable<Generic>> remsM = Memoizer.memoize(generic -> this.getDependencies((Generic)generic).getRemovals());
    private final Function<Generic, IDependencies<Generic>> depsM = Memoizer.memoize(ancestor -> {
        assert (ancestor != null);
        return new IDependencies<Generic>(){

            public Stream<Generic> unfilteredStream() {
                return ((AbstractServer.RootServerHandler)ancestor.getProxyHandler()).getDependencies().stream(Transaction.this.getTs());
            }

            public Observable<Generic> getAdds() {
                return ((AbstractServer.RootServerHandler)ancestor.getProxyHandler()).getDependencies().getAdds(Transaction.this.getTs());
            }

            public Observable<Generic> getRemovals() {
                return ((AbstractServer.RootServerHandler)ancestor.getProxyHandler()).getDependencies().getRemovals(Transaction.this.getTs());
            }

            public Snapshot<Generic> filter(List<IndexFilter> filters) {
                return ((AbstractServer.RootServerHandler)ancestor.getProxyHandler()).getDependencies().filter(filters, Transaction.this.getTs());
            }

            public Generic get(Object o) {
                return ((AbstractServer.RootServerHandler)ancestor.getProxyHandler()).getDependencies().get((Generic)o, Transaction.this.getTs());
            }

            public void add(Generic add) {
                ((AbstractServer.RootServerHandler)ancestor.getProxyHandler()).getDependencies().add(add);
            }

            public boolean remove(Generic remove) {
                return ((AbstractServer.RootServerHandler)ancestor.getProxyHandler()).getDependencies().remove(remove);
            }
        };
    });

    public Transaction(AbstractServer root, long ts) {
        super((Root)root);
        this.ts = ts;
    }

    public Transaction(AbstractServer root) {
        this(root, root.pickNewTs());
    }

    public AbstractServer getRoot() {
        return (AbstractServer)super.getRoot();
    }

    public long getTs() {
        return this.ts;
    }

    public Observable<IDifferential<Generic>> getDifferentialObservable() {
        throw new UnsupportedOperationException();
    }

    protected Generic plug(Generic generic) {
        if (this.getRoot().isInitialized()) {
            ((AbstractServer.RootServerHandler)generic.getProxyHandler()).getLifeManager().beginLife(this.getTs());
        }
        HashSet<Generic> set = new HashSet<Generic>();
        if (!generic.isMeta()) {
            set.add(generic.getMeta());
        }
        set.addAll(generic.getSupers());
        set.addAll(generic.getComponents());
        set.stream().forEach(ancestor -> this.getDependencies((Generic)ancestor).add((Object)generic));
        set.stream().forEach(ancestor -> ((AbstractServer.RootServerHandler)ancestor.getProxyHandler()).getDependencies().signalAdd(generic));
        return generic;
    }

    private void kill(Generic generic) {
        ((AbstractServer.RootServerHandler)generic.getProxyHandler()).getLifeManager().kill(this.getTs());
        this.getRoot().getGarbageCollector().add(generic);
    }

    private void signalRemoval(Generic generic) {
        HashSet<Generic> set = new HashSet<Generic>();
        if (!generic.isMeta()) {
            set.add(generic.getMeta());
        }
        set.addAll(generic.getSupers());
        set.addAll(generic.getComponents());
        set.stream().forEach(ancestor -> ((AbstractServer.RootServerHandler)ancestor.getProxyHandler()).getDependencies().signalRemoval(generic));
    }

    public IDependencies<Generic> getDependencies(Generic ancestor) {
        return this.depsM.apply(ancestor);
    }

    public void apply(Snapshot<Generic> removes, Snapshot<Generic> adds) throws ConcurrencyControlException, OptimisticLockConstraintViolationException {
        new LockedLifeManager().apply(removes, adds);
    }

    protected Generic buildAndPlug(Long ts, Class<?> clazz, Generic meta, List<Generic> supers, Serializable value, List<Generic> components, long[] otherTs) {
        return this.plug(this.getRoot().build(ts, clazz, meta, supers, value, components, otherTs));
    }

    public Observable<Generic> getAdds(Generic generic) {
        return this.addsM.apply(generic);
    }

    public Observable<Generic> getRemovals(Generic generic) {
        return this.remsM.apply(generic);
    }

    private class LockedLifeManager {
        private Set<LifeManager> lockedLifeManagers = new HashSet<LifeManager>();

        private LockedLifeManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void apply(Iterable<Generic> removes, Iterable<Generic> adds) throws ConcurrencyControlException, OptimisticLockConstraintViolationException {
            try {
                this.writeLockAllAndCheckMvcc(adds, removes);
                for (Generic remove : removes) {
                    Transaction.this.signalRemoval(remove);
                    Transaction.this.kill(remove);
                }
                for (Generic add : adds) {
                    Transaction.this.plug(add);
                }
            }
            finally {
                this.writeUnlockAll();
            }
        }

        private void writeLockAllAndCheckMvcc(Iterable<Generic> adds, Iterable<Generic> removes) throws ConcurrencyControlException, OptimisticLockConstraintViolationException {
            for (Generic remove : removes) {
                this.writeLockAndCheckMvcc(remove);
            }
            for (Generic add : adds) {
                this.writeLockAndCheckMvccForAdd(add);
            }
        }

        private void writeLockAndCheckMvccForAdd(Generic add) throws ConcurrencyControlException, OptimisticLockConstraintViolationException {
            this.writeLockAndCheckMvcc(add.getMeta());
            for (Generic superT : add.getSupers()) {
                this.writeLockAndCheckMvcc(superT);
            }
            for (Generic component : add.getComponents()) {
                this.writeLockAndCheckMvcc(component);
            }
            this.writeLockAndCheckMvcc(add);
        }

        private void writeLockAndCheckMvcc(Generic generic) throws ConcurrencyControlException, OptimisticLockConstraintViolationException {
            LifeManager manager;
            if (generic != null && !this.lockedLifeManagers.contains(manager = ((AbstractServer.RootServerHandler)generic.getProxyHandler()).getLifeManager())) {
                manager.writeLock();
                this.lockedLifeManagers.add(manager);
                manager.checkMvcc(Transaction.this.getTs());
            }
        }

        private void writeUnlockAll() {
            for (LifeManager lifeManager : this.lockedLifeManagers) {
                lifeManager.writeUnlock();
            }
            this.lockedLifeManagers = new HashSet<LifeManager>();
        }
    }
}

