/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import io.reactivex.Observable;
import io.reactivex.subjects.ReplaySubject;
import io.reactivex.subjects.Subject;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.genericsystem.api.core.FiltersBuilder;
import org.genericsystem.api.core.IGeneric;
import org.genericsystem.api.core.IndexFilter;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.common.AbstractIterator;
import org.genericsystem.common.Generic;
import org.genericsystem.common.SoftValueHashMap;
import org.genericsystem.kernel.AbstractServer;
import org.genericsystem.kernel.LifeManager;

abstract class AbstractTsDependencies {
    private final Map<Generic, Generic> map = new ConcurrentHashMap<Generic, Generic>();
    private final Subject<Generic> adds = ReplaySubject.create().toSerialized();
    private final Subject<Generic> removals = ReplaySubject.create().toSerialized();
    private final IndexNode indexesTree = new IndexNode(new IndexImpl(new IndexFilter(FiltersBuilder.NO_FILTER, new Object[0]), 0L, null), 0L, null);

    AbstractTsDependencies() {
    }

    public Stream<Generic> stream(long ts) {
        return this.indexesTree.getIndex(new ArrayList<IndexFilter>(), ts).stream(ts);
    }

    public Observable<Generic> getAdds(long ts) {
        return this.adds.hide().filter(g -> !((AbstractServer.RootServerHandler)g.getProxyHandler()).getLifeManager().isAlive(ts)).share();
    }

    public Observable<Generic> getRemovals(long ts) {
        return this.removals.hide().filter(g -> ((AbstractServer.RootServerHandler)g.getProxyHandler()).getLifeManager().isAlive(ts)).share();
    }

    public void signalAdd(Generic generic) {
        this.adds.onNext((Object)generic);
    }

    public void signalRemoval(Generic generic) {
        this.removals.onNext((Object)generic);
    }

    public abstract LifeManager getLifeManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Generic get(Generic generic, long ts) {
        Generic result = this.map.get(generic);
        if (result == null) {
            LifeManager lifeManager = this.getLifeManager();
            lifeManager.readLock();
            try {
                result = this.map.get(generic);
                lifeManager.atomicAdjustLastReadTs(ts);
            }
            finally {
                lifeManager.readUnlock();
            }
        }
        if (result != null && ((AbstractServer.RootServerHandler)result.getProxyHandler()).getLifeManager().isAlive(ts)) {
            return result;
        }
        return null;
    }

    public Snapshot<Generic> filter(final List<IndexFilter> filters, final long ts) {
        return new Snapshot<Generic>(){

            public Stream<Generic> unfilteredStream() {
                return AbstractTsDependencies.this.indexesTree.getIndex(filters, ts).stream(ts);
            }
        };
    }

    public void add(Generic generic) {
        this.indexesTree.add(generic);
    }

    public boolean remove(Generic generic) {
        return this.indexesTree.remove(generic);
    }

    private static class Node {
        Generic content;
        Node next;

        private Node(Generic content) {
            this.content = content;
        }
    }

    private class IndexNode {
        private long ts;
        private Index index;
        private final SoftReference<IndexNode> parent;
        private SoftValueTsHashMap children = new SoftValueTsHashMap();

        IndexNode(Index index, long ts, IndexNode parent) {
            this.index = index;
            this.ts = ts;
            this.parent = new SoftReference<IndexNode>(parent);
        }

        Index getIndex(List<IndexFilter> filters, long ts) {
            if (ts < this.ts) {
                this.index = new IndexImpl(this.index.getFilter(), ts, this.parent.get().index);
            }
            if (filters.isEmpty()) {
                return this.index;
            }
            return this.children.get(filters.get(0), ts).getIndex(filters.subList(1, filters.size()), ts);
        }

        public void add(Generic generic) {
            if (this.index.add(generic)) {
                this.children.values().forEach(childNode -> childNode.add(generic));
            }
        }

        public boolean remove(Generic generic) {
            boolean result = this.index.remove(generic);
            if (result) {
                this.children.values().forEach(childNode -> childNode.remove(generic));
            }
            return result;
        }

        private class SoftValueTsHashMap
        extends SoftValueHashMap<IndexFilter, IndexNode> {
            private SoftValueTsHashMap() {
            }

            public synchronized IndexNode get(Object key, long ts) {
                return (IndexNode)this.computeIfAbsent((IndexFilter)key, k -> new IndexNode(new IndexImpl((IndexFilter)k, ts, IndexNode.this.index), ts, IndexNode.this));
            }
        }
    }

    private class IndexImpl
    implements Index {
        private Node head = null;
        private Node tail = null;
        private final IndexFilter filter;

        IndexImpl(IndexFilter filter, long ts, Index parent) {
            this.filter = filter;
            if (parent != null) {
                parent.stream(ts).forEach(generic -> {
                    if (filter.test((IGeneric)generic)) {
                        this.add((Generic)generic);
                    }
                });
            }
        }

        @Override
        public boolean add(Generic generic) {
            assert (generic != null);
            if (this.filter.test((IGeneric)generic)) {
                Node newNode = new Node(generic);
                if (this.head == null) {
                    this.head = newNode;
                } else {
                    this.tail.next = newNode;
                }
                this.tail = newNode;
                AbstractTsDependencies.this.map.put(generic, generic);
                return true;
            }
            return false;
        }

        @Override
        public boolean remove(Generic generic) {
            assert (generic != null) : "generic is null";
            assert (this.head != null) : "head is null";
            Node currentNode = this.head;
            Generic currentContent = currentNode.content;
            if (generic.equals(currentContent)) {
                Node next = currentNode.next;
                this.head = next != null ? next : null;
                return true;
            }
            Node nextNode = currentNode.next;
            while (nextNode != null) {
                Generic nextGeneric = nextNode.content;
                Node nextNextNode = nextNode.next;
                if (generic.equals(nextGeneric)) {
                    nextNode.content = null;
                    if (nextNextNode == null) {
                        this.tail = currentNode;
                    }
                    currentNode.next = nextNextNode;
                    AbstractTsDependencies.this.map.remove(generic);
                    return true;
                }
                currentNode = nextNode;
                nextNode = nextNextNode;
            }
            return false;
        }

        @Override
        public Stream<Generic> stream(long ts) {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new InternalIterator(ts), 0), false);
        }

        @Override
        public IndexFilter getFilter() {
            return this.filter;
        }

        private class InternalIterator
        extends AbstractIterator<Node, Generic> {
            private final long ts;

            private InternalIterator(long iterationTs) {
                this.ts = iterationTs;
            }

            protected void advance() {
                Generic content;
                do {
                    Node nextNode;
                    Node node = nextNode = this.next == null ? IndexImpl.this.head : ((Node)this.next).next;
                    if (nextNode == null) {
                        LifeManager lifeManager = AbstractTsDependencies.this.getLifeManager();
                        lifeManager.readLock();
                        try {
                            Node node2 = nextNode = this.next == null ? IndexImpl.this.head : ((Node)this.next).next;
                            if (nextNode == null) {
                                this.next = null;
                                lifeManager.atomicAdjustLastReadTs(this.ts);
                                return;
                            }
                        }
                        finally {
                            lifeManager.readUnlock();
                        }
                    }
                    this.next = nextNode;
                } while ((content = ((Node)this.next).content) == null || !((AbstractServer.RootServerHandler)content.getProxyHandler()).getLifeManager().isAlive(this.ts));
            }

            protected Generic project() {
                return ((Node)this.next).content;
            }
        }
    }

    private static interface Index {
        public boolean add(Generic var1);

        public boolean remove(Generic var1);

        public Stream<Generic> stream(long var1);

        public IndexFilter getFilter();
    }
}

