/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.ServerWebSocket;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.genericsystem.common.AbstractBackEnd;
import org.genericsystem.common.AbstractCache;
import org.genericsystem.common.AbstractWebSocketsServer;
import org.genericsystem.common.EnginesDeploymentConfig;
import org.genericsystem.common.GSBuffer;
import org.genericsystem.kernel.AbstractServer;
import org.genericsystem.kernel.Engine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineServer
extends AbstractBackEnd {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Set<AbstractCache> caches = Collections.newSetFromMap(new ConcurrentHashMap());

    public static void main(String[] args) {
        new EngineServer((EnginesDeploymentConfig)new EnginesDeploymentConfig.DefaultPathSingleEngineDeployment("/", null)).start();
    }

    public EngineServer(EnginesDeploymentConfig options) {
        super(options.getHost(), options.getPort());
        logger.info("Load config : \n{}", (Object)options.encodePrettily());
        if (options.getEnginePaths().isEmpty()) {
            AbstractServer defaultRoot = this.buildRoot(null, Collections.emptyList());
            this.roots.put("/", defaultRoot);
            logger.info("Starts engine with path : / and persistence repository path : null");
        } else {
            for (String path : options.getEnginePaths()) {
                AbstractServer root = this.buildRoot(options.getPersistentDirectoryPath(path), options.getClasses(path));
                this.roots.put(path, root);
                logger.info("Starts engine with path: {} and persistence repository path: {}.", (Object)path, (Object)options.getPersistentDirectoryPath(path));
            }
        }
    }

    protected AbstractServer buildRoot(String persistentDirectoryPath, List<Class<?>> userClasses) {
        return new Engine(persistentDirectoryPath, (Class[])userClasses.stream().toArray(Class[]::new));
    }

    protected Buffer getReplyBuffer(int methodId, int op, AbstractServer root, GSBuffer gsBuffer) {
        GSBuffer replyBuffer = new GSBuffer().appendInt(op);
        switch (methodId) {
            case 0: {
                return replyBuffer.appendLongThrowException(() -> root.pickNewTs());
            }
            case 1: {
                return replyBuffer.appendGSVertexArrayThrowException(() -> root.getDependencies(gsBuffer.getLong(), gsBuffer.getLong()));
            }
            case 2: {
                return replyBuffer.appendGSVertexThrowException(() -> root.getVertex(gsBuffer.getLong()));
            }
            case 3: {
                return replyBuffer.appendLongThrowException(() -> {
                    root.apply(gsBuffer.getLong(), gsBuffer.getGSLongArray(), gsBuffer.getGSVertexArray());
                    return 0L;
                });
            }
        }
        return replyBuffer.appendLongThrowException(() -> {
            throw new IllegalStateException("unable to find method:" + methodId + " ");
        });
    }

    protected WebSocketsServer buildWebSocketsServer(String host, int port) {
        return new WebSocketsServer(host, port);
    }

    private class WebSocketsServer
    extends AbstractWebSocketsServer {
        public WebSocketsServer(String host, int port) {
            super(host, port);
        }

        public Handler<Buffer> getHandler(String path, ServerWebSocket socket) {
            AbstractServer root = (AbstractServer)((Object)EngineServer.this.roots.get(path));
            if (root == null) {
                throw new IllegalStateException("Unable to find database :" + path);
            }
            AbstractCache cache = root.newCache();
            return buffer -> {
                GSBuffer gsBuffer = new GSBuffer(buffer);
                int methodId = gsBuffer.getInt();
                int op = gsBuffer.getInt();
                cache.safeExecute(() -> socket.writeBinaryMessage(EngineServer.this.getReplyBuffer(methodId, op, root, gsBuffer)));
            };
        }

        public void addHttpHandler(HttpServer httpServer) {
        }

        public Handler<Void> getCloseHandler(ServerWebSocket socket) {
            return v -> logger.info("Close socket");
        }
    }
}

