/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.remote;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.WebSocket;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import org.genericsystem.common.GSVertx;
import org.genericsystem.remote.FrontEnd;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WebSocketClient {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final HttpClient httpClient;
    private CompletableFuture<WebSocket> webSocketPromise = new CompletableFuture();

    public WebSocketClient(FrontEnd client, String host, int port, String path) {
        this.httpClient = GSVertx.vertx().getVertx().createHttpClient(new HttpClientOptions().setDefaultPort(port).setDefaultHost(host != null ? host : "localhost"));
        this.webSocketPromise = this.getOpenPromise(client, path);
    }

    protected <T> void send(Buffer buffer) {
        this.webSocketPromise.thenAccept(webSocket -> webSocket.writeBinaryMessage(buffer));
    }

    protected <T> CompletableFuture<WebSocket> getOpenPromise(FrontEnd client, String path) {
        CompletableFuture<WebSocket> promise = new CompletableFuture<WebSocket>();
        this.httpClient.websocket(path, webSock -> {
            webSock.exceptionHandler(e -> promise.completeExceptionally((Throwable)e));
            webSock.handler(client.getHandler());
            promise.complete((WebSocket)webSock);
        });
        return promise;
    }

    public void close() {
        try {
            this.webSocketPromise.thenAccept(webSocket -> webSocket.close());
            logger.info("Close socket");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.httpClient.close();
            logger.info("Close httpClient");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

