/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.genericsystem.api.core.ApiStatics;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.api.core.exceptions.ConcurrencyControlException;
import org.genericsystem.api.core.exceptions.OptimisticLockConstraintViolationException;
import org.genericsystem.common.AbstractCache;
import org.genericsystem.common.Container;
import org.genericsystem.common.Generic;
import org.genericsystem.common.Protocol;
import org.genericsystem.common.Root;
import org.genericsystem.common.Statics;
import org.genericsystem.common.Vertex;
import org.genericsystem.kernel.AbstractTsDependencies;
import org.genericsystem.kernel.Archiver;
import org.genericsystem.kernel.GarbageCollector;
import org.genericsystem.kernel.LifeManager;
import org.genericsystem.kernel.Transaction;

public abstract class AbstractServer
extends Root
implements Generic,
Protocol {
    protected Archiver archiver;
    private final GarbageCollector garbageCollector = new GarbageCollector(this);
    private TsGenerator generator = new TsGenerator();

    public AbstractServer getRoot() {
        return this;
    }

    public abstract AbstractCache newCache();

    public void close() {
        super.close();
        this.archiver.close();
        this.garbageCollector.stopsScheduler();
    }

    GarbageCollector getGarbageCollector() {
        return this.garbageCollector;
    }

    protected Class<Generic> getTClass() {
        return Generic.class;
    }

    protected Generic build(Vertex vertex) {
        return super.build(vertex);
    }

    protected Generic build(Long ts, Class<?> clazz, Generic meta, List<Generic> supers, Serializable value, List<Generic> components, long birhTs) {
        long[] lArray;
        if (this.isInitialized()) {
            long[] lArray2 = new long[3];
            lArray2[0] = birhTs;
            lArray2[1] = 0L;
            lArray = lArray2;
            lArray2[2] = Long.MAX_VALUE;
        } else {
            lArray = ApiStatics.SYSTEM_TS;
        }
        return this.build(ts, clazz, meta, supers, value, components, lArray);
    }

    protected Generic build(Long ts, Class<?> clazz, Generic meta, List<Generic> supers, Serializable value, List<Generic> components, long[] otherTs) {
        return this.init(this.newT(this.adaptClass(clazz, meta)), this.buildHandler(clazz, meta, supers, value, components, ts == null ? this.pickNewTs() : ts.longValue(), otherTs));
    }

    protected RootServerHandler buildHandler(Class<?> clazz, Generic meta, List<Generic> supers, Serializable value, List<Generic> components, long ts, long[] otherTs) {
        return new RootServerHandler(clazz, meta, supers, value, components, ts, otherTs);
    }

    public long pickNewTs() {
        return this.generator.pickNewTs();
    }

    public Vertex getVertex(long id) {
        return this.getGenericById(id).getVertex();
    }

    public Vertex[] getDependencies(long ts, long id) {
        Generic ancestor = this.getGenericById(id);
        return ancestor != null ? (Vertex[])((RootServerHandler)ancestor.getProxyHandler()).getDependencies().stream(ts).map(generic -> generic.getVertex()).toArray(Vertex[]::new) : Statics.EMPTY;
    }

    public void apply(long ts, long[] removeIds, Vertex[] addVertices) throws ConcurrencyControlException, OptimisticLockConstraintViolationException {
        assert (Arrays.stream(addVertices).allMatch(addVertex -> this.getRoot().getGenericById(addVertex.getTs()) == null));
        assert (Arrays.stream(addVertices).allMatch(addVertex -> addVertex.getBirthTs() == Long.MAX_VALUE));
        Container removes = new Container(Arrays.stream(removeIds).mapToObj(removeId -> this.getRoot().getGenericById(removeId)));
        Container adds = new Container(Arrays.stream(addVertices).map(addVertex -> this.getRoot().build((Vertex)addVertex)));
        try {
            new Transaction(this, ts).apply((Snapshot<Generic>)removes, (Snapshot<Generic>)adds);
        }
        catch (ConcurrencyControlException | OptimisticLockConstraintViolationException e) {
            adds.forEach(add -> this.getRoot().release(add.getTs()));
            throw e;
        }
    }

    private static class TsGenerator {
        private final long startTime = System.currentTimeMillis() * 1000000L - System.nanoTime();
        private final AtomicLong lastTime = new AtomicLong(0L);

        private TsGenerator() {
        }

        public long pickNewTs() {
            long current;
            long nanoTs;
            while ((nanoTs = this.startTime + System.nanoTime()) - (current = this.lastTime.get()) <= 0L || !this.lastTime.compareAndSet(current, nanoTs)) {
            }
            return nanoTs;
        }
    }

    class RootServerHandler
    extends Root.DefaultHandler {
        private final LifeManager lifeManager;
        private final AbstractTsDependencies dependencies;

        private RootServerHandler(Class<?> clazz, Generic meta, List<Generic> supers, Serializable value, List<Generic> components, long ts, long[] otherTs) {
            super((Root)AbstractServer.this, clazz, meta, supers, value, components, ts);
            this.lifeManager = new LifeManager(otherTs);
            this.dependencies = new AbstractTsDependencies(){

                @Override
                public LifeManager getLifeManager() {
                    return RootServerHandler.this.lifeManager;
                }
            };
        }

        LifeManager getLifeManager() {
            return this.lifeManager;
        }

        AbstractTsDependencies getDependencies() {
            return this.dependencies;
        }

        protected AbstractServer getRoot() {
            return AbstractServer.this;
        }

        public long getBirthTs() {
            return this.lifeManager.getBirthTs();
        }
    }
}

