/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.remote;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.genericsystem.common.AbstractCache;
import org.genericsystem.common.Generic;
import org.genericsystem.common.Root;
import org.genericsystem.common.SystemCache;
import org.genericsystem.common.Vertex;
import org.genericsystem.remote.ClientCache;
import org.genericsystem.remote.FrontEnd;

public class ClientEngine
extends Root
implements Generic {
    protected final FrontEnd server;

    public ClientEngine(Class<?> ... userClasses) {
        this("0.0.0.0", 8082, userClasses);
    }

    public ClientEngine(String path, Class<?> ... userClasses) {
        this("0.0.0.0", 8082, path, userClasses);
    }

    public ClientEngine(String host, int port, Class<?> ... userClasses) {
        this(host, port, "/", userClasses);
    }

    public ClientEngine(String host, int port, String path, Class<?> ... userClasses) {
        assert (path != null);
        this.init(this, this.buildHandler(((Object)((Object)this)).getClass(), this, Collections.emptyList(), (Serializable)((Object)"Engine"), Collections.emptyList(), 0L, 0L));
        this.server = new FrontEnd(host, port, path);
        this.startSystemCache(userClasses);
        this.isInitialized = true;
    }

    public ClientEngine getRoot() {
        return this;
    }

    protected SystemCache buildSystemCache(Root root) {
        return new SystemCache(root){

            protected Generic getOrBuild(AbstractCache cache, Class<?> clazz, Generic meta, List<Generic> overrides, Serializable value, List<Generic> components) {
                Generic systemProperty = cache.get(meta, overrides, value, components);
                if (systemProperty == null) {
                    throw new IllegalStateException("Unable to find class on server : " + clazz.getName());
                }
                return systemProperty;
            }
        };
    }

    public ClientCache newCache() {
        return new ClientCache(this);
    }

    public ClientCache newCache(AbstractCache.ContextEventListener<Generic> listener) {
        return new ClientCache(this, listener);
    }

    public ClientCache getCurrentCache() {
        return (ClientCache)super.getCurrentCache();
    }

    Generic getGenericByVertex(Vertex vertex) {
        Generic generic = super.getGenericById(vertex.getTs());
        if (generic == null) {
            generic = this.build(vertex);
        }
        return generic;
    }

    public Generic getGenericById(long ts) {
        Generic generic = super.getGenericById(ts);
        if (generic == null) {
            Vertex vertex = this.server.getVertex(ts);
            generic = this.build(vertex);
        }
        return generic;
    }

    protected void finalize() throws Throwable {
        this.server.close();
        super.finalize();
    }

    public void close() {
        this.server.close();
        super.close();
    }

    protected Class<Generic> getTClass() {
        return Generic.class;
    }

    public FrontEnd getServer() {
        return this.server;
    }

    protected Generic build(Long ts, Class<?> clazz, Generic meta, List<Generic> supers, Serializable value, List<Generic> components, long birthTs) {
        return this.init(this.newT(this.adaptClass(clazz, meta)), this.buildHandler(clazz, meta, supers, value, components, ts == null ? this.pickNewTs() : ts.longValue(), birthTs));
    }

    ClientEngineHandler buildHandler(Class<?> clazz, Generic meta, List<Generic> supers, Serializable value, List<Generic> components, long ts, long birthTs) {
        return new ClientEngineHandler(clazz, meta, supers, value, components, ts, birthTs);
    }

    public long pickNewTs() {
        return this.server.pickNewTs();
    }

    class ClientEngineHandler
    extends Root.DefaultHandler {
        long birthTs;

        public ClientEngineHandler(Class<?> clazz, Generic meta, List<Generic> supers, Serializable value, List<Generic> components, long ts, long birthTs) {
            super((Root)ClientEngine.this, clazz, meta, supers, value, components, ts);
            this.birthTs = birthTs;
        }

        protected ClientEngine getRoot() {
            return ClientEngine.this;
        }

        public long getBirthTs() {
            return this.birthTs;
        }
    }
}

