/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.remote;

import io.reactivex.Observable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.api.core.exceptions.ConcurrencyControlException;
import org.genericsystem.api.core.exceptions.OptimisticLockConstraintViolationException;
import org.genericsystem.api.tools.Memoizer;
import org.genericsystem.common.CheckedContext;
import org.genericsystem.common.Container;
import org.genericsystem.common.Generic;
import org.genericsystem.common.IDifferential;
import org.genericsystem.common.Root;
import org.genericsystem.common.Vertex;
import org.genericsystem.remote.ClientEngine;

public class FrontEndTransaction
extends CheckedContext
implements IDifferential<Generic> {
    private final long ts;
    private final Function<Generic, Observable<Generic>> addsM = Memoizer.memoize(generic -> this.getDependencies((Generic)generic).getAdds());
    private final Function<Generic, Observable<Generic>> remsM = Memoizer.memoize(generic -> this.getDependencies((Generic)generic).getRemovals());
    private Map<Generic, Snapshot<Generic>> dependenciesMap = new HashMap<Generic, Snapshot<Generic>>();

    protected FrontEndTransaction(ClientEngine engine, long ts) {
        super((Root)engine);
        this.ts = ts;
    }

    protected FrontEndTransaction(ClientEngine engine) {
        this(engine, engine.pickNewTs());
    }

    public long getTs() {
        return this.ts;
    }

    public Observable<IDifferential<Generic>> getDifferentialObservable() {
        throw new UnsupportedOperationException();
    }

    public void apply(Snapshot<Generic> removes, Snapshot<Generic> adds) throws ConcurrencyControlException, OptimisticLockConstraintViolationException {
        assert (adds.stream().allMatch(add -> add.getBirthTs() == Long.MAX_VALUE));
        this.getRoot().getServer().apply(this.getTs(), removes.stream().mapToLong(g -> g.getTs()).toArray(), (Vertex[])adds.stream().map(g -> g.getVertex()).toArray(Vertex[]::new));
        removes.forEach(this::invalid);
        adds.forEach(this::invalid);
        adds.forEach(this::giveBirth);
    }

    private void giveBirth(Generic generic) {
        assert (Long.MAX_VALUE == generic.getBirthTs());
        ((ClientEngine.ClientEngineHandler)generic.getProxyHandler()).birthTs = this.getTs();
    }

    private void invalid(Generic generic) {
        generic.getComponents().forEach(component -> this.dependenciesMap.remove(component));
        generic.getSupers().forEach(superG -> this.dependenciesMap.remove(superG));
        this.dependenciesMap.remove(generic.getMeta());
        this.dependenciesMap.remove(generic);
    }

    public ClientEngine getRoot() {
        return (ClientEngine)super.getRoot();
    }

    public Snapshot<Generic> getDependencies(Generic generic) {
        Container dependencies = this.dependenciesMap.get(generic);
        if (dependencies == null) {
            dependencies = new Container(Arrays.stream(this.getRoot().getServer().getDependencies(this.getTs(), generic.getTs())).map(vertex -> this.getRoot().getGenericByVertex((Vertex)vertex)));
            Snapshot<Generic> result = this.dependenciesMap.put(generic, (Snapshot<Generic>)dependencies);
            assert (result == null);
        }
        return dependencies;
    }

    public Observable<Generic> getAdds(Generic generic) {
        return this.addsM.apply(generic);
    }

    public Observable<Generic> getRemovals(Generic generic) {
        return this.remsM.apply(generic);
    }
}

