/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import org.genericsystem.defaults.DefaultVertex;
import org.genericsystem.kernel.Context;
import org.genericsystem.kernel.LifeManager;
import org.genericsystem.kernel.Root;

public interface Generic
extends DefaultVertex<Generic>,
Comparable<Generic> {
    public Root getRoot();

    default public Context getCurrentCache() {
        return this.getRoot().getCurrentCache();
    }

    @Override
    default public int compareTo(Generic vertex) {
        long compareBirthTs;
        long birthTs = this.getLifeManager().getBirthTs();
        return birthTs == (compareBirthTs = vertex.getLifeManager().getBirthTs()) ? Long.compare(this.getTs(), vertex.getTs()) : Long.compare(birthTs, compareBirthTs);
    }

    default public LifeManager getLifeManager() {
        return this.getRoot().getLifeManager(this);
    }

    default public boolean isSystem() {
        return this.getLifeManager().isSystem();
    }

    default public Generic getNextDependency(Generic ancestor) {
        return this.getRoot().getNextDependency(this, ancestor);
    }

    public static class GenericImpl
    implements Generic {
        private Root root;

        Generic initRoot(Root root) {
            this.root = root;
            return this;
        }

        @Override
        public Root getRoot() {
            return this.root;
        }

        public String toString() {
            return this.defaultToString();
        }
    }
}

