/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cache;

import java.io.Serializable;
import org.genericsystem.cache.Cache;
import org.genericsystem.cache.GarbageCollector;
import org.genericsystem.cache.Transaction;
import org.genericsystem.kernel.Context;
import org.genericsystem.kernel.Generic;
import org.genericsystem.kernel.Root;

public class Engine
extends Root {
    protected final GarbageCollector garbageCollector = new GarbageCollector(this);

    public Engine(Class<?> ... userClasses) {
        this((Serializable)((Object)"Engine"), userClasses);
    }

    public Engine(Serializable engineValue, Class<?> ... userClasses) {
        this(engineValue, (String)null, userClasses);
    }

    public Engine(Serializable engineValue, String persistentDirectoryPath, Class<?> ... userClasses) {
        super(engineValue, persistentDirectoryPath, userClasses);
    }

    @Override
    public Cache newCache() {
        return new Cache(this);
    }

    @Override
    protected void flushContext() {
        this.getCurrentCache().flush();
    }

    public Cache newCache(Cache.ContextEventListener<Generic> listener) {
        return new Cache(new Transaction(this), listener);
    }

    protected Cache start(Cache cache) {
        this.contextWrapper.set(cache);
        return cache;
    }

    protected void stop(Cache cache) {
        this.garbageCollector.stopsScheduler();
        assert (this.contextWrapper.get() == cache);
        this.contextWrapper.set(null);
    }

    @Override
    public Cache getCurrentCache() {
        Cache currentCache = (Cache)this.contextWrapper.get();
        if (currentCache == null) {
            throw new IllegalStateException("Unable to find the current cache. Did you miss to call start() method on it ?");
        }
        return currentCache;
    }

    GarbageCollector getGarbageCollector() {
        return this.garbageCollector;
    }

    @Override
    protected Root.Wrapper buildContextWrapper() {
        return new LocalContextWrapper();
    }

    public static class LocalContextWrapper
    extends InheritableThreadLocal<Cache>
    implements Root.Wrapper {
        @Override
        public void set(Context context) {
            super.set((Cache)context);
        }
    }
}

