/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel.iterator;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.genericsystem.kernel.iterator.AbstractAwareIterator;
import org.genericsystem.kernel.iterator.AbstractFilterIterator;
import org.genericsystem.kernel.iterator.SingletonIterator;

public abstract class AbstractPreTreeLeafIterator<T>
extends AbstractAwareIterator<T> {
    private Set<T> alreadyTraversed = new HashSet<T>();
    protected Deque<Iterator<T>> deque = new ArrayDeque<Iterator<T>>();

    public AbstractPreTreeLeafIterator(T rootNode) {
        this.deque.push(new SingletonIterator<T>(rootNode));
    }

    @Override
    protected void advance() {
        while (!this.deque.isEmpty() && this.deque.peek().hasNext()) {
            AbstractFilterIterator children;
            Iterator<T> iterator = this.deque.peek();
            T node = iterator.next();
            if (!iterator.hasNext()) {
                this.deque.pop();
            }
            if ((children = new AbstractFilterIterator<T>(this.children(node)){

                @Override
                public boolean isSelected() {
                    return AbstractPreTreeLeafIterator.this.alreadyTraversed.add(this.next);
                }
            }).hasNext()) {
                this.deque.push(children);
                continue;
            }
            this.next = node;
            return;
        }
        this.next = null;
    }

    public abstract Iterator<T> children(T var1);

    @Override
    public void remove() {
        throw new IllegalStateException();
    }
}

