/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cache;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.genericsystem.api.core.IteratorSnapshot;
import org.genericsystem.kernel.iterator.AbstractGeneralAwareIterator;

public class PseudoConcurrentCollection<T>
implements IteratorSnapshot<T> {
    private Node<T> head = null;
    private Node<T> tail = null;
    final Map<T, T> map = new HashMap<T, T>();

    public void add(T element) {
        assert (element != null);
        Node newNode = new Node(element);
        if (this.head == null) {
            this.head = newNode;
        } else {
            ((Node)this.tail).next = newNode;
        }
        this.tail = newNode;
        this.map.put(element, element);
    }

    public boolean remove(T element) {
        Iterator<T> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!element.equals(iterator.next())) continue;
            iterator.remove();
            this.map.remove(element);
            return true;
        }
        return false;
    }

    public boolean removeIf(Predicate<? super T> filter) {
        Objects.requireNonNull(filter);
        boolean removed = false;
        Iterator<T> each = this.iterator();
        while (each.hasNext()) {
            if (!filter.test(each.next())) continue;
            each.remove();
            removed = true;
        }
        return removed;
    }

    public Iterator<T> iterator() {
        return new InternalIterator();
    }

    public T get(Object o) {
        return this.map.get(o);
    }

    private static class Node<T> {
        private final T content;
        private Node<T> next;

        private Node(T content) {
            this.content = content;
        }
    }

    public class InternalIterator
    extends AbstractGeneralAwareIterator<Node<T>, T>
    implements Iterator<T> {
        private Node<T> last;

        @Override
        protected void advance() {
            this.last = (Node)this.next;
            this.next = this.next == null ? PseudoConcurrentCollection.this.head : ((Node)this.next).next;
        }

        @Override
        public T project() {
            return ((Node)this.next).content;
        }

        @Override
        public void remove() {
            if (this.next == null) {
                throw new IllegalStateException();
            }
            if (this.last == null) {
                PseudoConcurrentCollection.this.head = ((Node)this.next).next;
                return;
            }
            this.last.next = ((Node)this.next).next;
            if (((Node)this.next).next == null) {
                PseudoConcurrentCollection.this.tail = this.last;
            }
        }
    }
}

