/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel.iterator;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.genericsystem.kernel.iterator.AbstractAwareIterator;

public abstract class AbstractPostTreeIterator<T>
extends AbstractAwareIterator<T> {
    protected Deque<T> stack = new ArrayDeque<T>();
    protected Map<T, Iterator<T>> visited = new HashMap<T, Iterator<T>>();

    public AbstractPostTreeIterator(T root) {
        this.stack.push(root);
    }

    protected abstract Iterator<T> children(T var1);

    @Override
    protected void advance() {
        while (!this.stack.isEmpty()) {
            this.next = this.stack.peek();
            Iterator<Object> iterator = this.visited.get(this.next);
            if (iterator == null) {
                iterator = this.children(this.next);
                this.visited.put(this.next, iterator);
            }
            if (!iterator.hasNext()) {
                this.stack.pop();
                return;
            }
            this.stack.push(iterator.next());
        }
        this.next = null;
    }
}

