/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.api.core.exceptions.ConcurrencyControlException;
import org.genericsystem.api.core.exceptions.OptimisticLockConstraintViolationException;
import org.genericsystem.defaults.DefaultVertex;
import org.genericsystem.kernel.Context;
import org.genericsystem.kernel.Generic;
import org.genericsystem.kernel.LifeManager;
import org.genericsystem.kernel.Root;

public class Transaction
extends Context {
    private final long ts;

    protected Transaction(Root root, long ts) {
        super(root);
        this.ts = ts;
    }

    protected Transaction(Root root) {
        this(root, root.pickNewTs());
    }

    @Override
    public final long getTs() {
        return this.ts;
    }

    public void apply(Iterable<Generic> removes, Iterable<Generic> adds) throws ConcurrencyControlException, OptimisticLockConstraintViolationException {
        new LockedLifeManager().apply(removes, adds);
    }

    @Override
    protected final Generic plug(Generic generic) {
        if (this.getRoot().isInitialized()) {
            generic.getLifeManager().beginLife(this.getTs());
        }
        HashSet<DefaultVertex> set = new HashSet<DefaultVertex>();
        if (!generic.isMeta()) {
            set.add(generic.getMeta());
        }
        set.addAll(generic.getSupers());
        set.addAll(generic.getComponents());
        set.stream().forEach(ancestor -> this.getRoot().getDependencies((Generic)ancestor).add(generic));
        this.getChecker().checkAfterBuild(true, false, generic);
        return generic;
    }

    @Override
    protected void unplug(Generic generic) {
        this.getChecker().checkAfterBuild(false, false, generic);
        generic.getLifeManager().kill(this.getTs());
        HashSet<DefaultVertex> set = new HashSet<DefaultVertex>();
        if (!generic.isMeta()) {
            set.add(generic.getMeta());
        }
        set.addAll(generic.getSupers());
        set.addAll(generic.getComponents());
        set.stream().forEach(ancestor -> this.getRoot().getDependencies((Generic)ancestor).remove(generic));
    }

    @Override
    public Snapshot<Generic> getDependencies(final Generic generic) {
        return new Snapshot<Generic>(){

            public Stream<Generic> stream() {
                return Transaction.this.getRoot().getDependencies(generic).stream(Transaction.this.getTs());
            }

            public Generic get(Object o) {
                return Transaction.this.getRoot().getDependencies(generic).get(o, Transaction.this.getTs());
            }
        };
    }

    private class LockedLifeManager {
        private Set<LifeManager> lockedLifeManagers = new HashSet<LifeManager>();

        private LockedLifeManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void apply(Iterable<Generic> removes, Iterable<Generic> adds) throws ConcurrencyControlException, OptimisticLockConstraintViolationException {
            try {
                this.writeLockAllAndCheckMvcc(adds, removes);
                for (Generic generic : removes) {
                    Transaction.this.unplug(generic);
                }
                for (Generic generic : adds) {
                    Transaction.this.plug(generic);
                }
            }
            finally {
                this.writeUnlockAll();
            }
        }

        private void applyAdd(Generic add) throws ConcurrencyControlException, OptimisticLockConstraintViolationException {
            try {
                this.writeLockAndCheckMvccForAdd(add);
                Transaction.this.plug(add);
            }
            finally {
                this.writeUnlockAll();
            }
        }

        private void applyRemove(Generic remove) throws ConcurrencyControlException, OptimisticLockConstraintViolationException {
            try {
                this.writeLockAndCheckMvcc(remove);
                Transaction.this.unplug(remove);
            }
            finally {
                this.writeUnlockAll();
            }
        }

        private void writeLockAllAndCheckMvcc(Iterable<Generic> adds, Iterable<Generic> removes) throws ConcurrencyControlException, OptimisticLockConstraintViolationException {
            for (Generic remove : removes) {
                this.writeLockAndCheckMvcc(remove);
            }
            for (Generic add : adds) {
                this.writeLockAndCheckMvccForAdd(add);
            }
        }

        private void writeLockAndCheckMvccForAdd(Generic add) throws ConcurrencyControlException, OptimisticLockConstraintViolationException {
            this.writeLockAndCheckMvcc((Generic)add.getMeta());
            for (Generic superT : add.getSupers()) {
                this.writeLockAndCheckMvcc(superT);
            }
            for (Generic component : add.getComponents()) {
                this.writeLockAndCheckMvcc(component);
            }
            this.writeLockAndCheckMvcc(add);
        }

        private void writeLockAndCheckMvcc(Generic generic) throws ConcurrencyControlException, OptimisticLockConstraintViolationException {
            LifeManager manager;
            if (generic != null && !this.lockedLifeManagers.contains(manager = generic.getLifeManager())) {
                manager.writeLock();
                this.lockedLifeManagers.add(manager);
                manager.checkMvcc(Transaction.this.getTs());
            }
        }

        private void writeUnlockAll() {
            for (LifeManager lifeManager : this.lockedLifeManagers) {
                lifeManager.writeUnlock();
            }
            this.lockedLifeManagers = new HashSet<LifeManager>();
        }
    }
}

