/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel.iterator;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import org.genericsystem.kernel.iterator.AbstractFilterIterator;
import org.genericsystem.kernel.iterator.SingletonIterator;

public abstract class AbstractPreTreeIterator<T>
extends HashSet<T>
implements Iterator<T> {
    private static final long serialVersionUID = -518282246760045090L;
    protected Deque<Iterator<T>> deque = new ArrayDeque<Iterator<T>>();

    public AbstractPreTreeIterator(T rootNode) {
        this.deque.push(new SingletonIterator<T>(rootNode));
    }

    @Override
    public boolean hasNext() {
        return !this.deque.isEmpty() && this.deque.peek().hasNext();
    }

    public abstract Iterator<T> children(T var1);

    @Override
    public T next() {
        AbstractFilterIterator children;
        Iterator<T> iterator = this.deque.peek();
        T node = iterator.next();
        if (!iterator.hasNext()) {
            this.deque.pop();
        }
        if ((children = new AbstractFilterIterator<T>(this.children(node)){

            @Override
            public boolean isSelected() {
                return AbstractPreTreeIterator.this.add(this.next);
            }
        }).hasNext()) {
            this.deque.push(children);
        }
        return node;
    }

    @Override
    public void remove() {
        throw new IllegalStateException();
    }
}

