/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.util.HashSet;
import java.util.stream.Stream;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.kernel.Context;
import org.genericsystem.kernel.Generic;
import org.genericsystem.kernel.Root;

public class Transaction
extends Context {
    private final long ts;

    protected Transaction(Root root, long ts) {
        super(root);
        this.ts = ts;
    }

    protected Transaction(Root root) {
        this(root, root.pickNewTs());
    }

    @Override
    public final long getTs() {
        return this.ts;
    }

    public void apply(Iterable<Generic> removes, Iterable<Generic> adds) {
        for (Generic generic : removes) {
            this.unplug(generic);
        }
        for (Generic generic : adds) {
            this.plug(generic);
        }
    }

    @Override
    protected Generic plug(Generic generic) {
        if (this.getRoot().isInitialized()) {
            generic.getLifeManager().beginLife(this.getTs());
        }
        HashSet<Generic> set = new HashSet<Generic>();
        if (!generic.isMeta()) {
            set.add(generic.getMeta());
        }
        set.addAll(generic.getSupers());
        set.addAll(generic.getComponents());
        set.stream().forEach(ancestor -> this.getRoot().getDependencies((Generic)ancestor).add(generic));
        this.getChecker().checkAfterBuild(true, false, generic);
        return generic;
    }

    @Override
    protected void unplug(Generic generic) {
        this.getChecker().checkAfterBuild(false, false, generic);
        generic.getLifeManager().kill(this.getTs());
        HashSet<Generic> set = new HashSet<Generic>();
        if (!generic.isMeta()) {
            set.add(generic.getMeta());
        }
        set.addAll(generic.getSupers());
        set.addAll(generic.getComponents());
        set.stream().forEach(ancestor -> this.getRoot().getDependencies((Generic)ancestor).remove(generic));
    }

    @Override
    public Snapshot<Generic> getDependencies(final Generic generic) {
        return new Snapshot<Generic>(){

            public Stream<Generic> stream() {
                return Transaction.this.getRoot().getDependencies(generic).stream(Transaction.this.getTs());
            }

            public Generic get(Object o) {
                return Transaction.this.getRoot().getDependencies(generic).get(o, Transaction.this.getTs());
            }
        };
    }
}

