/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.NavigableSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.genericsystem.kernel.Context;
import org.genericsystem.kernel.Generic;
import org.genericsystem.kernel.GenericHandler;

public class Restructurator {
    private final Context context;

    Restructurator(Context context) {
        this.context = context;
    }

    Generic rebuildAll(Generic toRebuild, Supplier<Generic> rebuilder, NavigableSet<Generic> dependenciesToRebuild) {
        dependenciesToRebuild.descendingSet().forEach(this.context::unplug);
        if (rebuilder != null) {
            ConvertMap convertMap = new ConvertMap();
            Generic build = rebuilder.get();
            if (toRebuild != null) {
                dependenciesToRebuild.remove(toRebuild);
                convertMap.put(toRebuild, build);
            }
            dependenciesToRebuild.forEach(x -> convertMap.convert(x));
            return build;
        }
        return null;
    }

    private class ConvertMap
    extends HashMap<Generic, Generic> {
        private static final long serialVersionUID = 5003546962293036021L;

        private ConvertMap() {
        }

        private Generic convert(Generic oldDependency) {
            if (oldDependency.isAlive()) {
                return oldDependency;
            }
            Generic newDependency = (Generic)this.get(oldDependency);
            if (newDependency == null) {
                if (oldDependency.isMeta()) {
                    assert (oldDependency.getSupers().size() == 1);
                    newDependency = Restructurator.this.context.setMeta(oldDependency.getComponents().size());
                } else {
                    List<Generic> overrides = this.reasignSupers(oldDependency, new ArrayList<Generic>());
                    List<Generic> components = this.reasignComponents(oldDependency);
                    Generic meta = this.reasignMeta(components, this.convert(oldDependency.getMeta()));
                    newDependency = new GenericHandler.AtomicHandler(Restructurator.this.context, meta, overrides, oldDependency.getValue(), components).resolve();
                }
                this.put(oldDependency, newDependency);
            }
            return newDependency;
        }

        private List<Generic> reasignSupers(Generic oldDependency, List<Generic> supersReasign) {
            for (Generic ancestor : oldDependency.getSupers().stream().map(x -> this.convert((Generic)x)).collect(Collectors.toList())) {
                if (!ancestor.isAlive()) {
                    this.reasignSupers(ancestor, supersReasign);
                    continue;
                }
                supersReasign.add(ancestor);
            }
            return supersReasign;
        }

        private List<Generic> reasignComponents(Generic oldDependency) {
            return oldDependency.getComponents().stream().map(x -> this.convert((Generic)x)).filter(x -> x.isAlive()).collect(Collectors.toList());
        }

        private Generic reasignMeta(List<Generic> components, Generic meta) {
            if (components.size() != meta.getComponents().size()) {
                return this.reasignMeta(components, meta.getSupers().get(0));
            }
            return meta;
        }

        @Override
        public Generic put(Generic oldDependency, Generic newDependency) {
            Generic result = super.put(oldDependency, newDependency);
            Restructurator.this.context.triggersMutation(oldDependency, newDependency);
            return result;
        }
    }
}

