/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.util.Iterator;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.genericsystem.kernel.Generic;
import org.genericsystem.kernel.LifeManager;
import org.genericsystem.kernel.iterator.AbstractAwareIterator;

public abstract class Dependencies {
    private Generic head = null;
    private Generic tail = null;
    private final ConcurrentHashMap<Generic, Generic> map = new ConcurrentHashMap();

    public abstract Generic getAncestor();

    private final LifeManager getLifeManager() {
        return this.getAncestor().getLifeManager();
    }

    public Stream<Generic> stream(long ts) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(ts), 0), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Generic get(Object generic, long ts) {
        Generic result = this.map.get(generic);
        if (result == null) {
            LifeManager lifeManager = this.getLifeManager();
            lifeManager.readLock();
            try {
                result = this.map.get(generic);
                lifeManager.atomicAdjustLastReadTs(ts);
            }
            finally {
                lifeManager.readUnlock();
            }
        }
        return result != null && result.getLifeManager().isAlive(ts) ? result : null;
    }

    public void add(Generic add) {
        assert (add != null);
        if (this.head == null) {
            this.head = add;
        } else {
            this.tail.getRoot().setNextDependency(this.tail, this.getAncestor(), add);
        }
        this.tail = add;
        Generic result = this.map.put(add, add);
        assert (result == null) : result.info();
    }

    public boolean remove(Generic generic) {
        assert (generic != null) : "generic is null";
        assert (this.head != null) : "head is null";
        Generic currentNode = this.head;
        Generic currentContent = currentNode;
        if (generic.equals(currentContent)) {
            Generic next = currentNode.getNextDependency(this.getAncestor());
            this.head = next != null ? next : null;
            return true;
        }
        Generic nextNode = currentNode.getNextDependency(this.getAncestor());
        while (nextNode != null) {
            Generic nextGeneric = nextNode;
            Generic nextNextNode = nextNode.getNextDependency(this.getAncestor());
            if (generic.equals(nextGeneric)) {
                if (nextNextNode == null) {
                    this.tail = currentNode;
                }
                currentNode.getRoot().setNextDependency(currentNode, this.getAncestor(), nextNextNode);
                this.map.remove(generic);
                return true;
            }
            currentNode = nextNode;
            nextNode = nextNextNode;
        }
        return false;
    }

    public Iterator<Generic> iterator(long ts) {
        return new InternalIterator(ts);
    }

    private class InternalIterator
    extends AbstractAwareIterator<Generic> {
        private final long ts;

        private InternalIterator(long iterationTs) {
            this.ts = iterationTs;
        }

        @Override
        protected void advance() {
            do {
                Generic nextDependency;
                Generic generic = nextDependency = this.next == null ? Dependencies.this.head : ((Generic)this.next).getNextDependency(Dependencies.this.getAncestor());
                if (nextDependency == null) {
                    LifeManager lifeManager = Dependencies.this.getLifeManager();
                    lifeManager.readLock();
                    try {
                        Generic generic2 = nextDependency = this.next == null ? Dependencies.this.head : ((Generic)this.next).getNextDependency(Dependencies.this.getAncestor());
                        if (nextDependency == null) {
                            this.next = null;
                            lifeManager.atomicAdjustLastReadTs(this.ts);
                            return;
                        }
                    }
                    finally {
                        lifeManager.readUnlock();
                    }
                }
                this.next = nextDependency;
            } while (!((Generic)this.next).getLifeManager().isAlive(this.ts));
        }
    }
}

