/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.api.core.annotations.InstanceClass;
import org.genericsystem.defaults.DefaultContext;
import org.genericsystem.kernel.Checker;
import org.genericsystem.kernel.Generic;
import org.genericsystem.kernel.GenericHandler;
import org.genericsystem.kernel.LifeManager;
import org.genericsystem.kernel.Restructurator;
import org.genericsystem.kernel.Root;

public abstract class Context
implements DefaultContext<Generic> {
    private final Root root;
    private final Checker checker;
    private final Builder builder;
    private final Restructurator restructurator;

    protected Context(Root root) {
        this.root = root;
        this.checker = this.buildChecker();
        this.builder = new Builder();
        this.restructurator = this.buildRestructurator();
    }

    public abstract long getTs();

    protected Checker buildChecker() {
        return new Checker(this);
    }

    protected Restructurator buildRestructurator() {
        return new Restructurator(this);
    }

    protected Checker getChecker() {
        return this.checker;
    }

    Builder getBuilder() {
        return this.builder;
    }

    Restructurator getRestructurator() {
        return this.restructurator;
    }

    public Root getRoot() {
        return this.root;
    }

    public final Generic[] newTArray(int dim) {
        return new Generic[dim];
    }

    Generic[] rootComponents(int dim) {
        Object[] components = this.newTArray(dim);
        Arrays.fill(components, this.root);
        return components;
    }

    protected Generic getMeta(int dim) {
        Generic adjustedMeta = (Generic)this.root.adjustMeta(this.rootComponents(dim));
        return adjustedMeta != null && adjustedMeta.getComponents().size() == dim ? adjustedMeta : null;
    }

    Generic setMeta(int dim) {
        return new GenericHandler.SetHandler(this, null, Collections.emptyList(), this.getRoot().getValue(), Arrays.asList(this.rootComponents(dim))).resolve();
    }

    public Generic addInstance(Generic meta, List<Generic> overrides, Serializable value, List<Generic> components) {
        return new GenericHandler.AddHandler(this, meta, overrides, value, components).resolve();
    }

    public Generic setInstance(Generic meta, List<Generic> overrides, Serializable value, List<Generic> components) {
        return new GenericHandler.SetHandler(this, meta, overrides, value, components).resolve();
    }

    public Generic update(Generic update, List<Generic> overrides, Serializable newValue, List<Generic> newComponents) {
        return new GenericHandler.UpdateHandler(this, update, update.getMeta(), overrides, newValue, newComponents).resolve();
    }

    public void forceRemove(Generic generic) {
        this.getRestructurator().rebuildAll(null, null, this.computeDependencies(generic));
    }

    public void remove(Generic generic) {
        this.getRestructurator().rebuildAll(null, null, this.computeRemoveDependencies(generic));
    }

    public void conserveRemove(Generic generic) {
        this.getRestructurator().rebuildAll(generic, () -> generic, this.computeDependencies(generic));
    }

    protected abstract Generic plug(Generic var1);

    protected abstract void unplug(Generic var1);

    protected void triggersMutation(Generic oldDependency, Generic newDependency) {
    }

    public abstract Snapshot<Generic> getDependencies(Generic var1);

    class Builder {
        Builder() {
        }

        protected Generic newT(Class<?> clazz, Generic meta) {
            InstanceClass metaAnnotation;
            InstanceClass instanceClass = metaAnnotation = meta == null ? null : this.getAnnotedClass(meta).getAnnotation(InstanceClass.class);
            if (metaAnnotation != null) {
                if (clazz == null || clazz.isAssignableFrom(metaAnnotation.value())) {
                    clazz = metaAnnotation.value();
                } else if (!metaAnnotation.value().isAssignableFrom(clazz)) {
                    Context.this.discardWithException(new InstantiationException(clazz + " must extends " + metaAnnotation.value()));
                }
            }
            try {
                if (clazz == null || !Generic.class.isAssignableFrom(clazz)) {
                    return new Generic.GenericImpl();
                }
                return (Generic)clazz.newInstance();
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
                Context.this.discardWithException(e);
                return null;
            }
        }

        Generic build(long ts, Class<?> clazz, Generic meta, List<Generic> supers, Serializable value, List<Generic> components, long[] otherTs) {
            return Context.this.getRoot().init(this.newT(clazz, meta), ts, meta, supers, value, components, otherTs);
        }

        Generic buildAndPlug(Class<?> clazz, Generic meta, List<Generic> supers, Serializable value, List<Generic> components) {
            return Context.this.plug(this.build(Context.this.getRoot().pickNewTs(), clazz, meta, supers, value, components, Context.this.getRoot().isInitialized() ? LifeManager.USER_TS : LifeManager.SYSTEM_TS));
        }

        Class<?> getAnnotedClass(Generic vertex) {
            Class<?> annotedClass;
            if (vertex.isSystem() && (annotedClass = Context.this.getRoot().findAnnotedClass(vertex)) != null) {
                return annotedClass;
            }
            return vertex.getClass();
        }
    }
}

