/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cache;

import java.util.stream.Stream;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.api.core.exceptions.ConcurrencyControlException;
import org.genericsystem.api.core.exceptions.OptimisticLockConstraintViolationException;
import org.genericsystem.api.core.exceptions.RollbackException;
import org.genericsystem.cache.AbstractDifferential;
import org.genericsystem.cache.PseudoConcurrentCollection;
import org.genericsystem.defaults.DefaultVertex;
import org.genericsystem.kernel.Checker;
import org.genericsystem.kernel.Generic;

public class Differential
extends AbstractDifferential {
    private final AbstractDifferential differential;
    private final PseudoConcurrentCollection<Generic> adds = new PseudoConcurrentCollection();
    private final PseudoConcurrentCollection<Generic> removes = new PseudoConcurrentCollection();

    public Differential(AbstractDifferential subCache) {
        this.differential = subCache;
    }

    public AbstractDifferential getSubCache() {
        return this.differential;
    }

    public int getCacheLevel() {
        return this.differential instanceof Differential ? ((Differential)this.differential).getCacheLevel() + 1 : 0;
    }

    @Override
    boolean isAlive(Generic generic) {
        return this.adds.contains(generic) || !this.removes.contains(generic) && this.differential.isAlive(generic);
    }

    void checkConstraints(Checker checker) throws RollbackException {
        this.adds.forEach(x -> checker.checkAfterBuild(true, true, (Generic)x));
        this.removes.forEach(x -> checker.checkAfterBuild(false, true, (Generic)x));
    }

    protected Generic plug(Generic generic) {
        this.adds.add(generic);
        return generic;
    }

    protected void unplug(Generic generic) {
        if (!this.adds.remove(generic)) {
            this.removes.add(generic);
        }
    }

    @Override
    Snapshot<Generic> getDependencies(final Generic generic) {
        return new Snapshot<Generic>(){

            public Generic get(Object o) {
                Generic result = (Generic)Differential.this.adds.get(o);
                if (result != null) {
                    return generic.isDirectAncestorOf(result) ? result : null;
                }
                return !Differential.this.removes.contains(o) ? (Generic)Differential.this.differential.getDependencies(generic).get(o) : null;
            }

            public Stream<Generic> stream() {
                return Stream.concat(Differential.this.differential.getDependencies(generic).stream().filter(x -> !Differential.this.removes.contains(x)), Differential.this.adds.stream().filter(x -> generic.isDirectAncestorOf((DefaultVertex)x)));
            }
        };
    }

    void apply() throws ConcurrencyControlException, OptimisticLockConstraintViolationException {
        this.getSubCache().apply((Iterable<Generic>)((Object)this.removes), (Iterable<Generic>)((Object)this.adds));
    }

    @Override
    protected void apply(Iterable<Generic> removes, Iterable<Generic> adds) throws ConcurrencyControlException, OptimisticLockConstraintViolationException {
        for (Generic generic : removes) {
            this.unplug(generic);
        }
        for (Generic generic : adds) {
            this.plug(generic);
        }
    }
}

