/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.genericsystem.defaults.DefaultVertex;

public class SupersComputer<T extends DefaultVertex<T>>
extends LinkedHashSet<T> {
    private static final long serialVersionUID = -1078004898524170057L;
    private final T meta;
    private final List<T> overrides;
    private final List<T> components;
    private final Serializable value;
    private final int reachLevel;
    private final Map<T, boolean[]> alreadyComputed = new HashMap<T, boolean[]>();

    SupersComputer(T meta, List<T> overrides, Serializable value, List<T> components) {
        assert (meta != null);
        this.reachLevel = this.isMeta(meta, value, components) ? 0 : meta.getLevel() + 1;
        this.meta = meta;
        this.overrides = overrides;
        this.components = components;
        this.value = value;
        this.visitSupers(meta);
    }

    private boolean isMeta(T meta, Serializable value, List<T> components) {
        return meta.isMeta() && components.stream().allMatch(c -> c != null && c.isRoot()) && Objects.equals(value, meta.getRoot().getValue());
    }

    private void visitSupers(T candidate) {
        if (candidate.getSupers().isEmpty()) {
            this.visit(candidate);
        } else {
            for (DefaultVertex superOfCandidate : candidate.getSupers()) {
                this.visitSupers(superOfCandidate);
            }
        }
    }

    private boolean[] visit(T candidate) {
        boolean isSuper;
        boolean[] result = this.alreadyComputed.get(candidate);
        if (result != null) {
            return result;
        }
        boolean isMeta = this.meta.isSpecializationOf(candidate);
        boolean bl = isSuper = !isMeta && candidate.isSuperOf(this.meta, this.overrides, this.value, this.components);
        if (!isMeta && !isSuper) {
            boolean[] selectableSelected = new boolean[]{true, false};
            this.alreadyComputed.put(candidate, selectableSelected);
            return selectableSelected;
        }
        boolean selectable = true;
        for (DefaultVertex inheriting : candidate.getInheritings()) {
            boolean[] subSelectionableSelectioned = this.visit(inheriting);
            if (subSelectionableSelectioned[0] && !subSelectionableSelectioned[1]) continue;
            selectable = false;
        }
        if (isMeta) {
            for (DefaultVertex instance : candidate.getInstances()) {
                boolean[] subSelectableSelected = this.visit(instance);
                if (subSelectableSelected[0] && !subSelectableSelected[1]) continue;
                selectable = false;
            }
        }
        boolean[] selectableSelected = new boolean[]{selectable, false};
        result = this.alreadyComputed.put(candidate, selectableSelected);
        assert (result == null) : candidate.info();
        if (selectableSelected[0] && candidate.getLevel() == this.reachLevel && !candidate.inheritsFrom(this.meta, this.overrides, this.value, this.components)) {
            this.add(candidate);
            selectableSelected[1] = true;
        }
        return selectableSelected;
    }
}

