/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.genericsystem.api.core.exceptions.ExistsException;
import org.genericsystem.kernel.Context;
import org.genericsystem.kernel.Generic;

abstract class GenericHandler {
    final Context context;
    final Generic meta;
    Generic adjustedMeta;
    final List<Generic> overrides;
    List<Generic> supers;
    final Serializable value;
    final List<Generic> components;
    Generic gettable;

    GenericHandler(Context context, Generic meta, List<Generic> overrides, Serializable value, List<Generic> components) {
        assert (overrides != null);
        this.context = context;
        this.meta = meta != null ? meta : context.getRoot();
        this.overrides = overrides;
        this.value = value;
        this.components = components;
        this.check();
        this.adjust();
    }

    private void check() {
        this.context.getChecker().checkBeforeBuild(this.meta, this.overrides, this.value, this.components);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isMeta() {
        if (!Objects.equals(this.context.getRoot().getValue(), this.value)) return false;
        if (!this.components.stream().allMatch(this.context.getRoot()::equals)) return false;
        return true;
    }

    void adjust() {
        this.adjustedMeta = (Generic)this.meta.adjustMeta(this.value, this.components);
        if (!this.isMeta() && this.adjustedMeta.getComponents().size() != this.components.size()) {
            this.adjustedMeta = this.context.setMeta(this.components.size());
        }
        this.supers = this.context.computeAndCheckOverridesAreReached(this.adjustedMeta, this.overrides, this.value, this.components);
    }

    Generic get() {
        if (this.gettable == null) {
            this.gettable = (Generic)this.adjustedMeta.getDirectInstance(this.supers, this.value, this.components);
        }
        return this.gettable;
    }

    Generic getEquiv() {
        return (Generic)this.adjustedMeta.getDirectEquivInstance(this.value, this.components);
    }

    public Generic getOrBuild() {
        Generic instance = this.get();
        return instance == null ? this.build() : instance;
    }

    Generic build() {
        this.gettable = this.context.getBuilder().buildAndPlug(null, this.isMeta() ? null : this.adjustedMeta, this.supers, this.value, this.components);
        return this.gettable;
    }

    Generic add() {
        return this.context.getRestructurator().rebuildAll(null, () -> this.build(), this.context.computePotentialDependencies(this.adjustedMeta, this.supers, this.value, this.components));
    }

    Generic set(Generic update) {
        assert (update != null);
        return this.context.getRestructurator().rebuildAll(update, () -> this.build(), this.context.computeDependencies(update));
    }

    Generic update(Generic update) {
        assert (update != null);
        return this.context.getRestructurator().rebuildAll(update, () -> this.getOrBuild(), this.context.computeDependencies(update));
    }

    static class SetArchiverHandler
    extends AtomicHandler {
        private final long ts;
        private final long[] otherGenerics;

        SetArchiverHandler(long ts, Context context, Generic meta, List<Generic> overrides, Serializable value, List<Generic> components, long[] otherGenerics) {
            super(context, meta, overrides, value, components);
            this.ts = ts;
            this.otherGenerics = otherGenerics;
        }

        @Override
        Generic build() {
            this.gettable = this.context.plug(this.context.getBuilder().build(this.ts, null, this.isMeta() ? null : this.adjustedMeta, this.supers, this.value, this.components, this.otherGenerics));
            return this.gettable;
        }
    }

    static class SetSystemHandler
    extends AtomicHandler {
        private final Class<?> clazz;

        SetSystemHandler(Context context, Class<?> clazz, Generic meta, List<Generic> overrides, Serializable value, List<Generic> components) {
            super(context, meta, overrides, value, components);
            this.clazz = clazz;
        }

        @Override
        Generic build() {
            this.gettable = this.context.getBuilder().buildAndPlug(this.clazz, this.isMeta() ? null : this.adjustedMeta, this.supers, this.value, this.components);
            return this.gettable;
        }
    }

    static class AtomicHandler
    extends GenericHandler {
        AtomicHandler(Context context, Generic meta, List<Generic> overrides, Serializable value, List<Generic> components) {
            super(context, meta, overrides, value, components);
        }

        final Generic resolve() {
            return this.getOrBuild();
        }
    }

    static class UpdateHandler
    extends GenericHandler {
        private final Generic update;

        UpdateHandler(Context context, Generic update, Generic meta, List<Generic> overrides, Serializable value, List<Generic> components) {
            super(context, meta, overrides, value, components);
            this.update = update;
        }

        Generic resolve() {
            return this.update(this.update);
        }
    }

    static class SetHandler
    extends GenericHandler {
        SetHandler(Context context, Generic meta, List<Generic> overrides, Serializable value, List<Generic> components) {
            super(context, meta, overrides, value, components);
        }

        Generic resolve() {
            Generic generic = this.get();
            if (generic != null) {
                return generic;
            }
            generic = this.getEquiv();
            return generic == null ? this.add() : this.set(generic);
        }
    }

    static class AddHandler
    extends GenericHandler {
        AddHandler(Context context, Generic meta, List<Generic> overrides, Serializable value, List<Generic> components) {
            super(context, meta, overrides, value, components);
        }

        Generic resolve() {
            Generic generic = this.get();
            if (generic != null) {
                this.context.discardWithException((Throwable)new ExistsException("An equivalent instance already exists : " + generic.info()));
            }
            return this.add();
        }
    }

    static class GetHandler
    extends GenericHandler {
        GetHandler(Context context, Generic gettable) {
            super(context, gettable.getMeta(), gettable.getSupers(), gettable.getValue(), gettable.getComponents());
            this.gettable = gettable;
            this.adjustedMeta = gettable.getMeta();
            this.supers = gettable.getSupers();
        }

        GetHandler(Context context, Generic meta, List<Generic> overrides, Serializable value, List<Generic> components) {
            super(context, meta, overrides, value, components);
        }

        Generic resolve() {
            return this.get();
        }
    }
}

