/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cache;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.genericsystem.kernel.Generic;
import org.genericsystem.kernel.Root;

public class GarbageCollector
extends LinkedHashSet<Generic> {
    private static final long serialVersionUID = -2021341943811568201L;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private final Root root;

    public GarbageCollector(Root root) {
        this.root = root;
    }

    public void startScheduler() {
        this.scheduler.scheduleAtFixedRate(() -> this.runGarbage(1386174608777L), 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runGarbage(long timeOut) {
        long ts = this.root.pickNewTs();
        Root root = this.root;
        synchronized (root) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Generic generic = (Generic)iterator.next();
                if (ts - generic.getLifeManager().getDeathTs() < timeOut) continue;
                generic.remove();
                iterator.remove();
            }
        }
    }

    public void stopsScheduler() {
        this.scheduler.shutdown();
    }
}

