/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cache;

import java.util.HashSet;
import java.util.Set;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.api.core.exceptions.CacheNoStartedException;
import org.genericsystem.api.core.exceptions.ConcurrencyControlException;
import org.genericsystem.api.core.exceptions.OptimisticLockConstraintViolationException;
import org.genericsystem.api.core.exceptions.RollbackException;
import org.genericsystem.cache.AbstractCacheElement;
import org.genericsystem.cache.CacheElement;
import org.genericsystem.cache.Engine;
import org.genericsystem.cache.Transaction;
import org.genericsystem.kernel.Context;
import org.genericsystem.kernel.Generic;
import org.genericsystem.kernel.LifeManager;

public class Cache
extends Context {
    protected Transaction transaction;
    protected CacheElement cacheElement;
    private final ContextEventListener<Generic> listener;

    protected Cache(Engine engine) {
        this(new Transaction(engine));
    }

    protected Cache(Transaction subContext) {
        this(subContext, new ContextEventListener<Generic>(){});
    }

    protected Cache(Transaction subContext, ContextEventListener<Generic> listener) {
        super(subContext.getRoot());
        this.listener = listener;
        this.transaction = subContext;
        this.initialize();
    }

    @Override
    public long getTs() {
        return this.transaction.getTs();
    }

    @Override
    public Snapshot<Generic> getDependencies(Generic vertex) {
        return this.cacheElement.getDependencies(vertex);
    }

    protected void initialize() {
        this.cacheElement = new CacheElement(this.cacheElement == null ? new TransactionElement() : this.cacheElement.getSubCache());
    }

    public void shift() throws RollbackException {
        this.transaction = new Transaction(this.getRoot(), this.getRoot().pickNewTs());
        this.listener.triggersRefreshEvent();
    }

    public void tryFlush() throws ConcurrencyControlException {
        if (!this.equals(this.getRoot().getCurrentCache())) {
            this.discardWithException((Throwable)new CacheNoStartedException("The Cache isn't started"));
        }
        try {
            this.checkConstraints();
            this.doSynchronizedApplyInSubContext();
            this.initialize();
            this.listener.triggersFlushEvent();
        }
        catch (OptimisticLockConstraintViolationException exception) {
            this.discardWithException(exception);
        }
    }

    public void flush() {
        ConcurrencyControlException cause = null;
        for (int attempt = 0; attempt < 50; ++attempt) {
            try {
                this.tryFlush();
                return;
            }
            catch (ConcurrencyControlException e) {
                cause = e;
                try {
                    Thread.sleep(15L);
                    this.shift();
                }
                catch (InterruptedException ex) {
                    this.discardWithException(ex);
                }
                continue;
            }
        }
        this.discardWithException(cause);
    }

    protected void doSynchronizedApplyInSubContext() throws ConcurrencyControlException, OptimisticLockConstraintViolationException {
        CacheElement originalCacheElement = this.cacheElement;
        if (this.cacheElement.getSubCache() instanceof CacheElement) {
            this.cacheElement = (CacheElement)this.cacheElement.getSubCache();
        }
        try {
            this.synchronizedApply(originalCacheElement);
        }
        finally {
            this.cacheElement = originalCacheElement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizedApply(CacheElement cacheElement) throws ConcurrencyControlException, OptimisticLockConstraintViolationException {
        Engine engine = this.getRoot();
        synchronized (engine) {
            cacheElement.apply();
        }
    }

    public void clear() {
        this.initialize();
        this.listener.triggersClearEvent();
        this.listener.triggersRefreshEvent();
    }

    public void mount() {
        this.cacheElement = new CacheElement(this.cacheElement);
    }

    public void unmount() {
        AbstractCacheElement subCache = this.cacheElement.getSubCache();
        this.cacheElement = subCache instanceof CacheElement ? (CacheElement)subCache : new CacheElement(subCache);
        this.listener.triggersClearEvent();
        this.listener.triggersRefreshEvent();
    }

    @Override
    public Engine getRoot() {
        return (Engine)super.getRoot();
    }

    public Cache start() {
        return this.getRoot().start(this);
    }

    public void stop() {
        this.getRoot().stop(this);
    }

    @Override
    protected void triggersMutation(Generic oldDependency, Generic newDependency) {
        if (this.listener != null) {
            this.listener.triggersMutationEvent(oldDependency, newDependency);
        }
    }

    @Override
    protected Generic plug(Generic generic) {
        this.cacheElement.plug(generic);
        this.getChecker().checkAfterBuild(true, false, generic);
        return generic;
    }

    @Override
    protected void unplug(Generic generic) {
        this.getChecker().checkAfterBuild(false, false, generic);
        this.cacheElement.unplug(generic);
    }

    protected void checkConstraints() throws RollbackException {
        this.cacheElement.checkConstraints(this.getChecker());
    }

    public void discardWithException(Throwable exception) throws RollbackException {
        this.clear();
        throw new RollbackException(exception);
    }

    public int getCacheLevel() {
        return this.cacheElement.getCacheLevel();
    }

    public static interface ContextEventListener<X> {
        default public void triggersMutationEvent(X oldDependency, X newDependency) {
        }

        default public void triggersRefreshEvent() {
        }

        default public void triggersClearEvent() {
        }

        default public void triggersFlushEvent() {
        }
    }

    protected class TransactionElement
    extends AbstractCacheElement {
        private Set<LifeManager> lockedLifeManagers = new HashSet<LifeManager>();

        protected TransactionElement() {
        }

        private void writeLockAllAndCheckMvcc(Iterable<Generic> adds, Iterable<Generic> removes) throws ConcurrencyControlException, OptimisticLockConstraintViolationException {
            for (Generic remove : removes) {
                this.writeLockAndCheckMvcc(remove);
            }
            for (Generic add : adds) {
                this.writeLockAndCheckMvcc(add.getMeta());
                for (Generic superT : add.getSupers()) {
                    this.writeLockAndCheckMvcc(superT);
                }
                for (Generic component : add.getComponents()) {
                    this.writeLockAndCheckMvcc(component);
                }
                this.writeLockAndCheckMvcc(add);
            }
        }

        private void writeLockAndCheckMvcc(Generic generic) throws ConcurrencyControlException, OptimisticLockConstraintViolationException {
            LifeManager manager;
            if (generic != null && !this.lockedLifeManagers.contains(manager = generic.getLifeManager())) {
                manager.writeLock();
                this.lockedLifeManagers.add(manager);
                manager.checkMvcc(Cache.this.getTs());
            }
        }

        private void writeUnlockAll() {
            for (LifeManager lifeManager : this.lockedLifeManagers) {
                lifeManager.writeUnlock();
            }
            this.lockedLifeManagers = new HashSet<LifeManager>();
        }

        @Override
        protected void apply(Iterable<Generic> removes, Iterable<Generic> adds) throws ConcurrencyControlException, OptimisticLockConstraintViolationException {
            try {
                this.writeLockAllAndCheckMvcc(adds, removes);
                Cache.this.transaction.apply(removes, adds);
            }
            finally {
                this.writeUnlockAll();
            }
        }

        @Override
        boolean isAlive(Generic generic) {
            return Cache.this.transaction.isAlive(generic);
        }

        @Override
        Snapshot<Generic> getDependencies(Generic vertex) {
            return Cache.this.transaction.getDependencies(vertex);
        }
    }
}

