/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.genericsystem.defaults.DefaultLifeManager;
import org.genericsystem.defaults.DefaultRoot;
import org.genericsystem.kernel.Archiver;
import org.genericsystem.kernel.Config;
import org.genericsystem.kernel.Context;
import org.genericsystem.kernel.Dependencies;
import org.genericsystem.kernel.Generic;
import org.genericsystem.kernel.LifeManager;
import org.genericsystem.kernel.SystemCache;
import org.genericsystem.kernel.Transaction;
import org.genericsystem.kernel.Vertex;

public class Root
extends Generic.GenericImpl
implements DefaultRoot<Generic> {
    private final TsGenerator generator = new TsGenerator();
    private Context context;
    private final SystemCache systemCache;
    private final Archiver archiver;
    private final Map<Generic, Vertex> map = new ConcurrentHashMap<Generic, Vertex>();
    private boolean initialized = false;

    public Root(Class<?> ... userClasses) {
        this((Serializable)((Object)"Engine"), userClasses);
    }

    public Root(Serializable value, Class<?> ... userClasses) {
        this(value, (String)null, userClasses);
    }

    @Override
    public Root getRoot() {
        return this;
    }

    public Root(Serializable value, String persistentDirectoryPath, Class<?> ... userClasses) {
        this.init(this, 0L, null, Collections.emptyList(), value, Collections.emptyList(), DefaultLifeManager.SYSTEM_TS);
        this.startContext();
        this.systemCache = new SystemCache(this, this.getClass());
        this.systemCache.mount(Arrays.asList(Config.MetaAttribute.class, Config.MetaRelation.class, Config.SystemMap.class, Config.Sequence.class), userClasses);
        this.flushContext();
        this.archiver = new Archiver(this, persistentDirectoryPath);
        this.initialized = true;
        this.shiftContext();
    }

    protected void startContext() {
        this.context = new Transaction(this, this.pickNewTs());
    }

    protected void flushContext() {
    }

    protected void shiftContext() {
        this.context = new Transaction(this, this.pickNewTs());
    }

    public long pickNewTs() {
        return this.generator.pickNewTs();
    }

    boolean isInitialized() {
        return this.initialized;
    }

    public final Generic getMetaAttribute() {
        return this.find(Config.MetaAttribute.class);
    }

    public final Generic getMetaRelation() {
        return this.find(Config.MetaRelation.class);
    }

    @Override
    public Context getCurrentCache() {
        return this.context;
    }

    public <Custom extends Generic> Custom find(Class<?> clazz) {
        return (Custom)this.systemCache.get(clazz);
    }

    public Class<?> findAnnotedClass(Generic vertex) {
        return this.systemCache.getByVertex(vertex);
    }

    public void close() {
        this.archiver.close();
    }

    Context buildTransaction() {
        return new Transaction(this, this.pickNewTs());
    }

    public Generic getMap() {
        return this.find(Config.SystemMap.class);
    }

    private Vertex getVertex(Generic generic) {
        return this.map.get(generic);
    }

    public Generic getSequence() {
        return this.find(Config.Sequence.class);
    }

    long getTs(Generic generic) {
        return this.getVertex(generic).getTs();
    }

    Generic getMeta(Generic generic) {
        return this.getVertex(generic).getMeta();
    }

    Generic getNextDependency(Generic generic, Generic ancestor) {
        return this.getVertex(generic).getNextDependency(ancestor);
    }

    void setNextDependency(Generic generic, Generic ancestor, Generic nextDependency) {
        this.getVertex(generic).setNextDependency(ancestor, nextDependency);
    }

    LifeManager getLifeManager(Generic generic) {
        return this.getVertex(generic).getLifeManager();
    }

    List<Generic> getSupers(Generic generic) {
        return this.getVertex(generic).getSupers();
    }

    Serializable getValue(Generic generic) {
        return this.getVertex(generic).getValue();
    }

    List<Generic> getComponents(Generic generic) {
        return this.getVertex(generic).getComponents();
    }

    Dependencies<Generic> getDependencies(Generic generic) {
        return this.getVertex(generic).getDependencies();
    }

    Generic init(Generic generic, long ts, Generic meta, List<Generic> supers, Serializable value, List<Generic> components, long[] otherTs) {
        Vertex result = this.map.putIfAbsent(generic, new Vertex(generic, ts, meta, supers, value, components, otherTs));
        assert (result == null);
        return ((Generic.GenericImpl)generic).init(this);
    }

    public static class TsGenerator {
        private final long startTime = System.currentTimeMillis() * 1000000L - System.nanoTime();
        private final AtomicLong lastTime = new AtomicLong(0L);

        public long pickNewTs() {
            long current;
            long nanoTs;
            while ((nanoTs = this.startTime + System.nanoTime()) - (current = this.lastTime.get()) <= 0L || !this.lastTime.compareAndSet(current, nanoTs)) {
            }
            return nanoTs;
        }
    }
}

