/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.genericsystem.kernel.Context;
import org.genericsystem.kernel.DefaultGeneric;
import org.genericsystem.kernel.LifeManager;
import org.genericsystem.kernel.Root;

public interface Generic
extends DefaultGeneric<Generic> {
    public Root getRoot();

    default public Context getCurrentCache() {
        return this.getRoot().getCurrentCache();
    }

    @Override
    default public LifeManager getLifeManager() {
        return this.getRoot().getLifeManager(this);
    }

    @Override
    default public int compareTo(Generic vertex) {
        long compareBirthTs;
        long birthTs = this.getLifeManager().getBirthTs();
        return birthTs == (compareBirthTs = vertex.getLifeManager().getBirthTs()) ? Long.compare(this.getTs(), vertex.getTs()) : Long.compare(birthTs, compareBirthTs);
    }

    @Override
    default public long getTs() {
        return this.getRoot().getTs(this);
    }

    default public Generic getMeta() {
        return this.getRoot().getMeta(this);
    }

    default public List<Generic> getSupers() {
        return this.getRoot().getSupers(this);
    }

    default public Serializable getValue() {
        return this.getRoot().getValue(this);
    }

    default public List<Generic> getComponents() {
        return this.getRoot().getComponents(this);
    }

    default public Generic getNextDependency(Generic ancestor) {
        return this.getRoot().getNextDependency(this, ancestor);
    }

    public static class GenericImpl
    implements Generic {
        private Root root;

        Generic init(Root root) {
            this.root = root;
            return this;
        }

        @Override
        public Root getRoot() {
            return this.root;
        }

        public String toString() {
            return Objects.toString(this.getValue());
        }
    }
}

