/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.genericsystem.api.core.ApiStatics;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.api.exception.UnreachableOverridesException;
import org.genericsystem.defaults.DefaultContext;
import org.genericsystem.kernel.Builder;
import org.genericsystem.kernel.Checker;
import org.genericsystem.kernel.Generic;
import org.genericsystem.kernel.GenericHandler;
import org.genericsystem.kernel.Restructurator;
import org.genericsystem.kernel.Root;
import org.genericsystem.kernel.SupersComputer;

public abstract class Context
implements DefaultContext<Generic> {
    private final Root root;
    private final Checker checker;
    private final Builder builder;
    private final Restructurator restructurator;

    protected Context(Root root) {
        this.root = root;
        this.checker = this.buildChecker();
        this.builder = this.buildBuilder();
        this.restructurator = this.buildRestructurator();
    }

    public abstract long getTs();

    protected Checker buildChecker() {
        return new Checker(this);
    }

    protected abstract Builder buildBuilder();

    protected Restructurator buildRestructurator() {
        return new Restructurator(this);
    }

    protected Checker getChecker() {
        return this.checker;
    }

    Builder getBuilder() {
        return this.builder;
    }

    Restructurator getRestructurator() {
        return this.restructurator;
    }

    public Root getRoot() {
        return this.root;
    }

    public final Generic[] newTArray(int dim) {
        return this.builder.newTArray(dim);
    }

    Generic[] rootComponents(int dim) {
        Object[] components = this.newTArray(dim);
        Arrays.fill(components, this.root);
        return components;
    }

    List<Generic> computeAndCheckOverridesAreReached(Generic adjustedMeta, List<Generic> overrides, Serializable value, List<Generic> components) {
        ArrayList<Generic> supers = new ArrayList<Generic>(new SupersComputer<Generic>(adjustedMeta, overrides, value, components));
        if (!ApiStatics.areOverridesReached(supers, overrides)) {
            this.discardWithException((Throwable)new UnreachableOverridesException("Unable to reach overrides : " + overrides + " with computed supers : " + supers));
        }
        return supers;
    }

    protected Generic getMeta(int dim) {
        Generic adjustedMeta = (Generic)this.root.adjustMeta(this.root.getValue(), this.rootComponents(dim));
        return adjustedMeta != null && adjustedMeta.getComponents().size() == dim ? adjustedMeta : null;
    }

    Generic setMeta(int dim) {
        return new GenericHandler.SetHandler(this, null, Collections.emptyList(), this.getRoot().getValue(), Arrays.asList(this.rootComponents(dim))).resolve();
    }

    public Generic addInstance(Generic meta, List<Generic> overrides, Serializable value, List<Generic> components) {
        return new GenericHandler.AddHandler(this, meta, overrides, value, components).resolve();
    }

    public Generic setInstance(Generic meta, List<Generic> overrides, Serializable value, List<Generic> components) {
        return new GenericHandler.SetHandler(this, meta, overrides, value, components).resolve();
    }

    public Generic update(Generic update, List<Generic> overrides, Serializable newValue, List<Generic> newComponents) {
        return new GenericHandler.UpdateHandler(this, update, update.getMeta(), overrides, newValue, newComponents).resolve();
    }

    public void forceRemove(Generic generic) {
        this.getRestructurator().rebuildAll(null, null, this.builder.getContext().computeDependencies(generic));
    }

    public void remove(Generic generic) {
        this.getRestructurator().rebuildAll(null, null, this.builder.getContext().computeRemoveDependencies(generic));
    }

    public void conserveRemove(Generic generic) {
        this.getRestructurator().rebuildAll(generic, () -> generic, this.builder.getContext().computeDependencies(generic));
    }

    protected abstract Generic plug(Generic var1);

    protected abstract void unplug(Generic var1);

    protected void triggersMutation(Generic oldDependency, Generic newDependency) {
    }

    public abstract Snapshot<Generic> getDependencies(Generic var1);
}

