/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.genericsystem.api.exception.AliveConstraintViolationException;
import org.genericsystem.api.exception.ConstraintViolationException;
import org.genericsystem.api.exception.CrossEnginesAssignementsException;
import org.genericsystem.api.exception.LevelConstraintViolationException;
import org.genericsystem.api.exception.MetaRuleConstraintViolationException;
import org.genericsystem.api.exception.NotAliveConstraintViolationException;
import org.genericsystem.api.exception.NotAllowedSerializableTypeException;
import org.genericsystem.api.exception.ReferentialIntegrityConstraintViolationException;
import org.genericsystem.api.exception.RollbackException;
import org.genericsystem.defaults.DefaultVertex;
import org.genericsystem.defaults.constraints.Constraint;
import org.genericsystem.kernel.Config;
import org.genericsystem.kernel.Context;
import org.genericsystem.kernel.Generic;
import org.genericsystem.kernel.Root;
import org.genericsystem.kernel.annotations.Priority;
import org.genericsystem.kernel.systemproperty.AxedPropertyClass;

public class Checker {
    private final Context context;
    private final Comparator<Generic> CONSTRAINT_PRIORITY = new Comparator<Generic>(){

        @Override
        public int compare(Generic constraintHolder, Generic compareConstraintHolder) {
            return Checker.this.getConstraintPriority(constraintHolder.getMeta()) < Checker.this.getConstraintPriority(compareConstraintHolder.getMeta()) ? -1 : 1;
        }
    };

    public Checker(Context context) {
        this.context = context;
    }

    public Context getContext() {
        return this.context;
    }

    public void checkBeforeBuild(Generic meta, List<Generic> overrides, Serializable value, List<Generic> components) throws RollbackException {
        this.checkSystemConstraintsBeforeBuild(meta, overrides, value, components);
    }

    public void checkAfterBuild(boolean isOnAdd, boolean isFlushTime, Generic vertex) throws RollbackException {
        this.checkSystemConstraintsAfterBuild(isOnAdd, isFlushTime, vertex);
        this.checkConsistency(vertex);
        this.checkConstraints(isOnAdd, isFlushTime, vertex);
    }

    private void checkSystemConstraintsBeforeBuild(Generic meta, List<Generic> overrides, Serializable value, List<Generic> components) {
        this.checkSameEngine(meta, overrides, components);
        this.checkIsAlive(meta, overrides, components);
        this.checkSerializableType(value);
        this.checkWellFormedMeta(meta, value, components);
    }

    private void checkSameEngine(Generic meta, List<Generic> overrides, List<Generic> components) {
        if (meta == null) {
            return;
        }
        Root root = meta.getRoot();
        for (Generic component : components) {
            if (root.equals(component.getRoot())) continue;
            this.context.discardWithException((Throwable)new CrossEnginesAssignementsException("Unable to associate meta " + meta + " with his component " + component + " because they are from differents engines"));
        }
        for (Generic directSuper : overrides) {
            if (directSuper == null || root.equals(directSuper.getRoot())) continue;
            this.context.discardWithException((Throwable)new CrossEnginesAssignementsException("Unable to associate meta " + meta + " with his super " + directSuper + " because they are from differents engines"));
        }
    }

    private void checkIsAlive(Generic meta, List<Generic> overrides, List<Generic> components) {
        if (meta != null) {
            this.checkIsAlive(meta);
        }
        overrides.forEach(x -> this.checkIsAlive((Generic)x));
        components.forEach(x -> this.checkIsAlive((Generic)x));
    }

    private void checkSerializableType(Serializable value) {
        if (value == null) {
            return;
        }
        if (value instanceof AxedPropertyClass) {
            return;
        }
        if (value instanceof Boolean) {
            return;
        }
        if (value instanceof byte[]) {
            return;
        }
        if (value instanceof Double) {
            return;
        }
        if (value instanceof Float) {
            return;
        }
        if (value instanceof Integer) {
            return;
        }
        if (value instanceof Long) {
            return;
        }
        if (value instanceof Short) {
            return;
        }
        if (value instanceof String) {
            return;
        }
        if (value instanceof Class) {
            return;
        }
        this.context.discardWithException((Throwable)new NotAllowedSerializableTypeException("Not allowed type for your serializable. Only primitive and Byte[] allowed."));
    }

    private void checkWellFormedMeta(Generic meta, Serializable value, List<Generic> components) {
        if (meta == null && (components.stream().anyMatch(x -> !x.isRoot()) || !Objects.equals(value, this.context.getRoot().getValue()))) {
            this.context.discardWithException(new IllegalStateException("Malformed meta : (" + meta + ") " + value + " " + components));
        }
    }

    private void checkWellFormedMeta(Generic vertex) {
        if (vertex.isMeta() && (vertex.getComponents().stream().anyMatch(c -> !c.isRoot()) || !Objects.equals(vertex.getValue(), this.context.getRoot().getValue()) || vertex.getSupers().size() != 1 || !vertex.getSupers().get(0).isMeta())) {
            this.context.discardWithException(new IllegalStateException("Malformed meta : " + vertex.info()));
        }
    }

    protected void checkSystemConstraintsAfterBuild(boolean isOnAdd, boolean isFlushTime, Generic vertex) {
        this.checkWellFormedMeta(vertex);
        if (isOnAdd || !isFlushTime) {
            this.checkIsAlive(vertex);
        } else {
            this.checkIsNotAlive(vertex);
        }
        if (!isOnAdd) {
            this.checkDependenciesAreEmpty(vertex);
        }
        this.checkSameEngine(vertex);
        this.checkDependsMetaComponents(vertex);
        this.checkSupers(vertex);
        this.checkDependsSuperComponents(vertex);
        this.checkLevel(vertex);
        this.checkLevelComponents(vertex);
        this.checkSignatureUnicity(vertex);
        this.checkRemoveGenericAnnoted(isOnAdd, vertex);
    }

    private void checkRemoveGenericAnnoted(boolean isOnAdd, Generic vertex) {
        if (!isOnAdd && vertex.isSystem()) {
            this.getContext().discardWithException(new IllegalAccessException("System node can't be removed " + vertex.info()));
        }
    }

    private void checkIsAlive(Generic vertex) {
        if (!this.context.isAlive(vertex)) {
            this.context.discardWithException((Throwable)new AliveConstraintViolationException(vertex.info()));
        }
    }

    private void checkIsNotAlive(Generic vertex) {
        if (this.context.isAlive(vertex)) {
            this.context.discardWithException((Throwable)new NotAliveConstraintViolationException(vertex.info()));
        }
    }

    private void checkDependenciesAreEmpty(Generic vertex) {
        if (!this.context.getDependencies(vertex).isEmpty()) {
            this.context.discardWithException((Throwable)new ReferentialIntegrityConstraintViolationException("Unable to remove : " + vertex.info() + " cause it has dependencies"));
        }
    }

    private void checkSameEngine(Generic vertex) {
        Root root = vertex.getRoot();
        for (Generic component : vertex.getComponents()) {
            if (root.equals(component.getRoot())) continue;
            this.context.discardWithException((Throwable)new CrossEnginesAssignementsException("Unable to associate his " + vertex + " with his component " + component + " because they are from differents engines"));
        }
        for (Generic directSuper : vertex.getSupers()) {
            if (directSuper == null || root.equals(directSuper.getRoot())) continue;
            this.context.discardWithException((Throwable)new CrossEnginesAssignementsException("Unable to associate his " + vertex + " with his super " + directSuper + " because they are from differents engines"));
        }
    }

    private void checkDependsMetaComponents(Generic vertex) {
        if (vertex.getMeta().getComponents().size() != vertex.getComponents().size()) {
            this.context.discardWithException((Throwable)new MetaRuleConstraintViolationException("Added generic and its meta do not have the same components size. Added node components : " + vertex.getComponents() + " and meta components : " + vertex.getMeta().getComponents()));
        }
        for (int pos = 0; pos < vertex.getComponents().size(); ++pos) {
            Generic component = (Generic)vertex.getComponent(pos);
            Generic metaComponent = (Generic)vertex.getMeta().getComponent(pos);
            if (component == null) {
                if (metaComponent == null) continue;
                component = vertex;
            } else if (metaComponent == null) {
                metaComponent = vertex.getMeta();
            }
            if (component.isInstanceOf(metaComponent) || component.inheritsFrom(metaComponent)) continue;
            this.context.discardWithException((Throwable)new MetaRuleConstraintViolationException("Component of added generic : " + component + " must be instance of or must inherits from the component of its meta : " + metaComponent));
        }
    }

    private void checkSupers(Generic vertex) {
        if (!vertex.getSupers().stream().allMatch(superVertex -> superVertex.getLevel() == vertex.getLevel())) {
            this.context.discardWithException(new IllegalStateException("Inconsistant supers (bad level) : " + vertex.getSupers()));
        }
        if (!vertex.getSupers().stream().allMatch(superVertex -> vertex.getMeta().inheritsFrom(superVertex.getMeta()))) {
            this.context.discardWithException(new IllegalStateException("Inconsistant supers : " + vertex.getSupers()));
        }
        if (!vertex.getSupers().stream().noneMatch(this::equals)) {
            this.context.discardWithException(new IllegalStateException("Supers loop detected : " + vertex.info()));
        }
    }

    private void checkDependsSuperComponents(Generic vertex) {
        vertex.getSupers().forEach(superVertex -> {
            if (!superVertex.isSuperOf(vertex.getMeta(), vertex.getSupers(), vertex.getValue(), vertex.getComponents())) {
                this.context.discardWithException(new IllegalStateException("Inconsistant components : " + vertex.getComponents()));
            }
        });
    }

    private void checkLevel(Generic vertex) {
        if (vertex.getLevel() > 2) {
            this.context.discardWithException((Throwable)new LevelConstraintViolationException("Unable to instanciate a concrete generic : " + vertex.getMeta()));
        }
    }

    private void checkLevelComponents(Generic vertex) {
        for (Generic component : vertex.getComponents()) {
            if (component.getLevel() <= vertex.getLevel()) continue;
            this.context.discardWithException((Throwable)new LevelConstraintViolationException("Inappropriate component meta level : " + component.getLevel() + " for component : " + component + ". Component meta level for added node is : " + vertex.getLevel()));
        }
    }

    private void checkSignatureUnicity(Generic vertex) {
    }

    private void checkConstraints(boolean isOnAdd, boolean isFlushTime, Generic vertex) {
        Object map = this.getContext().getRoot().find(Config.SystemMap.class);
        if (map != null) {
            Stream<Generic> contraintsHolders = vertex.getMeta().getHolders((DefaultVertex)map).get().filter(holder -> holder.getMeta().getValue() instanceof AxedPropertyClass && Constraint.class.isAssignableFrom(((AxedPropertyClass)holder.getMeta().getValue()).getClazz())).filter(holder -> holder.getValue() != null && !Boolean.FALSE.equals(holder.getValue())).sorted(this.CONSTRAINT_PRIORITY);
            contraintsHolders.forEach(constraintHolder -> {
                Generic targetComponent;
                Generic baseComponent = (Generic)constraintHolder.getBaseComponent();
                if (vertex.isSpecializationOf(baseComponent)) {
                    this.check((Generic)constraintHolder, baseComponent, isFlushTime, isOnAdd, false, vertex);
                }
                if ((targetComponent = (Generic)constraintHolder.getTargetComponent()) != null && vertex.isSpecializationOf(targetComponent)) {
                    this.check((Generic)constraintHolder, baseComponent, isFlushTime, isOnAdd, true, vertex);
                }
            });
        }
    }

    private void check(Generic constraintHolder, Generic baseComponent, boolean isFlushTime, boolean isOnAdd, boolean isRevert, Generic vertex) {
        try {
            this.statelessConstraint(constraintHolder.getMeta()).check((DefaultVertex)vertex, (DefaultVertex)baseComponent, constraintHolder.getValue(), ((AxedPropertyClass)constraintHolder.getMeta().getValue()).getAxe(), isOnAdd, isFlushTime, isRevert);
        }
        catch (ConstraintViolationException e) {
            this.context.discardWithException(e);
        }
    }

    private Constraint<Generic> statelessConstraint(Generic vertex) {
        try {
            return (Constraint)((AxedPropertyClass)vertex.getValue()).getClazz().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.context.discardWithException(e);
            return null;
        }
    }

    private int getConstraintPriority(Generic vertex) {
        Class clazz = ((AxedPropertyClass)vertex.getValue()).getClazz();
        Priority priority = clazz.getAnnotation(Priority.class);
        return priority != null ? priority.value() : 0;
    }

    private void checkConsistency(Generic vertex) {
        Object map = this.getContext().getRoot().find(Config.SystemMap.class);
        if (map != null && vertex.isInstanceOf((DefaultVertex)map) && vertex.getMeta().getValue() instanceof AxedPropertyClass && Constraint.class.isAssignableFrom(((AxedPropertyClass)vertex.getMeta().getValue()).getClazz()) && vertex.getValue() != null && !Boolean.FALSE.equals(vertex.getValue())) {
            Generic baseConstraint = (Generic)vertex.getComponent(0);
            int axe = ((AxedPropertyClass)vertex.getMeta().getValue()).getAxe();
            if (((AxedPropertyClass)vertex.getMeta().getValue()).getAxe() == -1) {
                baseConstraint.getAllInstances().forEach(x -> this.check(vertex, baseConstraint, true, true, false, (Generic)x));
            } else {
                baseConstraint.getComponents().get(axe).getAllInstances().forEach(x -> this.check(vertex, baseConstraint, true, true, true, (Generic)x));
            }
        }
    }
}

