/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.Serializable;
import java.util.List;
import org.genericsystem.defaults.DefaultLifeManager;
import org.genericsystem.kernel.Context;
import org.genericsystem.kernel.Generic;
import org.genericsystem.kernel.annotations.InstanceClass;

public abstract class Builder {
    private final Context context;

    protected Builder(Context context) {
        this.context = context;
    }

    public Context getContext() {
        return this.context;
    }

    public final Generic[] newTArray(int dim) {
        return new Generic[dim];
    }

    protected Generic newT(Class<?> clazz, Generic meta) {
        InstanceClass metaAnnotation;
        InstanceClass instanceClass = metaAnnotation = meta == null ? null : this.getAnnotedClass(meta).getAnnotation(InstanceClass.class);
        if (metaAnnotation != null) {
            if (clazz == null || clazz.isAssignableFrom(metaAnnotation.value())) {
                clazz = metaAnnotation.value();
            } else if (!metaAnnotation.value().isAssignableFrom(clazz)) {
                this.getContext().discardWithException(new InstantiationException(clazz + " must extends " + metaAnnotation.value()));
            }
        }
        try {
            if (clazz == null || !Generic.class.isAssignableFrom(clazz)) {
                return new Generic.GenericImpl();
            }
            return (Generic)clazz.newInstance();
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
            this.getContext().discardWithException(e);
            return null;
        }
    }

    abstract Class<?> getAnnotedClass(Generic var1);

    abstract Generic buildAndPlug(Class<?> var1, Generic var2, List<Generic> var3, Serializable var4, List<Generic> var5);

    abstract Generic build(long var1, Class<?> var3, Generic var4, List<Generic> var5, Serializable var6, List<Generic> var7, long[] var8);

    public static class GenericBuilder
    extends Builder {
        public GenericBuilder(Context context) {
            super(context);
        }

        @Override
        Generic build(long ts, Class<?> clazz, Generic meta, List<Generic> supers, Serializable value, List<Generic> components, long[] otherTs) {
            return this.getContext().getRoot().init(this.newT(clazz, meta), ts, meta, supers, value, components, otherTs);
        }

        @Override
        Generic buildAndPlug(Class<?> clazz, Generic meta, List<Generic> supers, Serializable value, List<Generic> components) {
            return this.getContext().plug(this.build(this.getContext().getRoot().pickNewTs(), clazz, meta, supers, value, components, this.getContext().getRoot().isInitialized() ? DefaultLifeManager.USER_TS : DefaultLifeManager.SYSTEM_TS));
        }

        @Override
        Class<?> getAnnotedClass(Generic vertex) {
            Class<?> annotedClass;
            if (vertex.isSystem() && (annotedClass = this.getContext().getRoot().findAnnotedClass(vertex)) != null) {
                return annotedClass;
            }
            return vertex.getClass();
        }
    }
}

