/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cache;

import java.io.Serializable;
import org.genericsystem.cache.Cache;
import org.genericsystem.cache.DefaultEngine;
import org.genericsystem.cache.GarbageCollector;
import org.genericsystem.cache.Transaction;
import org.genericsystem.kernel.Generic;
import org.genericsystem.kernel.Root;

public class Engine
extends Root
implements DefaultEngine {
    private final GarbageCollector garbageCollector = new GarbageCollector(this);
    private ThreadLocal<Cache> cacheLocal;

    public Engine(Class<?> ... userClasses) {
        this((Serializable)((Object)"Engine"), userClasses);
    }

    public Engine(Serializable engineValue, Class<?> ... userClasses) {
        this(engineValue, (String)null, userClasses);
    }

    public Engine(Serializable engineValue, String persistentDirectoryPath, Class<?> ... userClasses) {
        super(engineValue, persistentDirectoryPath, userClasses);
    }

    public Cache newCache() {
        return new Cache(this);
    }

    @Override
    protected void startContext() {
        this.cacheLocal = new ThreadLocal();
        this.start(this.newCache());
    }

    @Override
    protected void flushContext() {
        this.getCurrentCache().flush();
    }

    @Override
    protected void shiftContext() {
        this.getCurrentCache().pickNewTs();
    }

    @Override
    public GarbageCollector getGarbageCollector() {
        return this.garbageCollector;
    }

    public Cache newCache(Cache.ContextEventListener<Generic> listener) {
        return new Cache(new Transaction(this), listener);
    }

    @Override
    public Cache start(Cache cache) {
        if (!this.equals(cache.getRoot())) {
            throw new IllegalStateException();
        }
        this.cacheLocal.set(cache);
        return cache;
    }

    @Override
    public void stop(Cache cache) {
        this.garbageCollector.stopsScheduler();
        assert (this.cacheLocal.get() == cache);
        this.cacheLocal.set(null);
    }

    @Override
    public Cache getCurrentCache() {
        Cache currentCache = this.cacheLocal.get();
        if (currentCache == null) {
            throw new IllegalStateException("Unable to find the current cache. Did you miss to call start() method on it ?");
        }
        return currentCache;
    }
}

