/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cache;

import java.util.stream.Stream;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.api.exception.ConcurrencyControlException;
import org.genericsystem.api.exception.OptimisticLockConstraintViolationException;
import org.genericsystem.api.exception.RollbackException;
import org.genericsystem.cache.AbstractCacheElement;
import org.genericsystem.defaults.DefaultVertex;
import org.genericsystem.kernel.Checker;
import org.genericsystem.kernel.Generic;
import org.genericsystem.kernel.PseudoConcurrentCollection;

public class CacheElement
extends AbstractCacheElement {
    private final AbstractCacheElement subCache;
    private final PseudoConcurrentCollection<Generic> adds = new PseudoConcurrentCollection();
    private final PseudoConcurrentCollection<Generic> removes = new PseudoConcurrentCollection();

    public CacheElement(AbstractCacheElement subCache) {
        this.subCache = subCache;
    }

    public AbstractCacheElement getSubCache() {
        return this.subCache;
    }

    public int getCacheLevel() {
        return this.subCache instanceof CacheElement ? ((CacheElement)this.subCache).getCacheLevel() + 1 : 0;
    }

    @Override
    boolean isAlive(Generic generic) {
        return this.adds.contains(generic) || !this.removes.contains(generic) && this.subCache.isAlive(generic);
    }

    void checkConstraints(Checker checker) throws RollbackException {
        this.adds.forEach(x -> checker.checkAfterBuild(true, true, (Generic)x));
        this.removes.forEach(x -> checker.checkAfterBuild(false, true, (Generic)x));
    }

    protected Generic plug(Generic generic) {
        this.adds.add(generic);
        return generic;
    }

    protected void unplug(Generic generic) {
        if (!this.adds.remove(generic)) {
            this.removes.add(generic);
        }
    }

    @Override
    Snapshot<Generic> getDependencies(final Generic generic) {
        return new Snapshot<Generic>(){

            public Generic get(Object o) {
                Generic result = (Generic)CacheElement.this.adds.get(o);
                if (result != null) {
                    return generic.isDirectAncestorOf(result) ? result : null;
                }
                return !CacheElement.this.removes.contains(o) ? (Generic)CacheElement.this.subCache.getDependencies(generic).get(o) : null;
            }

            public Stream<Generic> get() {
                return Stream.concat(CacheElement.this.subCache.getDependencies(generic).get().filter(x -> !CacheElement.this.removes.contains(x)), CacheElement.this.adds.get().filter(x -> generic.isDirectAncestorOf((DefaultVertex)x)));
            }
        };
    }

    void apply() throws ConcurrencyControlException, OptimisticLockConstraintViolationException {
        this.getSubCache().apply((Iterable<Generic>)((Object)this.removes), (Iterable<Generic>)((Object)this.adds));
    }

    @Override
    protected void apply(Iterable<Generic> removes, Iterable<Generic> adds) throws ConcurrencyControlException, OptimisticLockConstraintViolationException {
        for (Generic generic : removes) {
            this.unplug(generic);
        }
        for (Generic generic : adds) {
            this.plug(generic);
        }
    }
}

